let main_view = document.querySelector(".main-view");

if (localStorage.getItem("USER-SESSION") && localStorage.getItem("PROJECT-NAME")) {
    window.open("play.php","_self");
}else{
    main_view.classList.remove("hide_view"); 
}

let apiTargetURL = "",USER_MOBILE_NUM = "",USER_PASSWORD = "",USER_INPUT_OTP="";
let isContactAvailable = "false";

let home_btn = document.querySelector(".home-btn");
let search_btn = document.querySelector(".search-btn");
let account_btn = document.querySelector(".account-btn");
let fragment_view = document.querySelector(".fragment-view");

let login_container = document.querySelector(".login-container");
let home_container = document.querySelector(".home-container");
let search_container = document.querySelector(".search-container");
let register_container = document.querySelector(".register-container");
let reset_container = document.querySelector(".reset-container");

let input_api_target = document.querySelector("#input_api_target");
let input_platform_type = document.querySelector("#input_platform_type");
let input_refer_code = document.querySelector("#input_refer_code");

function modifyURLs(screen){
  let newUrlIS =  '';
  if(screen=="home"){
    newUrlIS =  window.location.origin + '/#/';
  }else if(screen=="my"){
    newUrlIS =  window.location.origin + '/#/login';
  }else{
    newUrlIS =  window.location.origin + '/#/'+screen;
  }
  
  history.replaceState({}, null, newUrlIS);
}

function setDisableAllBtns(screen) {
    if(screen!='contact'){
       home_container.classList.add("hide_view");
  	  search_container.classList.add("hide_view");
  	  login_container.classList.add("hide_view");   
    }
	
	if(screen=='account'){
	  isContactAvailable = "true";
	  document.querySelector(".search-btn p").innerHTML = "Contact";
   	  document.querySelector(".search-btn img").src = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAAAXNSR0IArs4c6QAABJJJREFUaEPtmFtoHGUUx39nkrSuqA9aH2pEUKnWC0pp+1CtkOKDoKZQhfiQVhDMZWfbSkubnRUfWpTubFJqabOzSSo+aPtQwQuNIEiKgSp9sMYLxFtRX0zyIIqoGNtk98hMLm6a3Z2ZZDdNMN/j7rn8f+ecme+bT1jiS5a4fpYBrnYHK9eBI0ciXDO6xgP8J3KRvXtHKwFbPoBMch056hDZCroGpHamYB0CuYjqGQz6iSY+LwfQ/AC6X11N7nIzqs8A94QU9A0ipzFW9NCyZySk77T53ACOHVtJzaiFajNwy1yTT/oNI9LDWMRm9+5LYWOFBzjRcTuXs28hbCiQzBUwhDKMeCMzNGGjtajUIh6sO1orZ/kqF1hR1UDT/p/CQIQDSNubEc4VSPAnSCcylib60qToIjIyr9SiNTHQncD1BUAeIWZ9HBQiOEDX4XvJjQ8WCJymKtdJy4vfBk3q2XUfWkvWcCFis/yM6vto3fd1kHjBADzxY+dBbvgvqP6F8CzRxLtBEhW1ySS3obwBcl1e7D8wajYFgQgG4NgXgPV5IkYwZAet8bPzEj/l3JV6lJy+CazOi/cZplXoOZuR0h/ASTaDdOd5fY8hjbTGXajyra7UBnJ6CrgrrxMtmImeUkkCAFxRfTHqiba9Xz7leZEy7U+iud4wXSgNkEk1onoyL2AvprW1IuKngjr2GaB+OofIdqJxtzMFV2mAdPIkIo3TnoZsLPvoXClrYpQ+nf5Z9RSxxPa5ATj2r8CNE85ymmyuC9FRqnI/+77vw7bJ3R+yxq2oRKgyWsE7nrjrN0zrpvAAx5N1VMlHxXXIJ6haYTadgrG8zVFs0IeL5srqFnYl+gv9X3yEnOTzICdKFlL5hWpjEy1tP4QtuGff3X4n47nzCDeX9tcmzMRr4QDSdgqhzVeYqkMsMXs39XUE0sk0IqavqdJOzIqHA3Dst4GnfIPDd5jW2gB2s00c2z1+3B3A9x1M6+mwAO781wUIDqblv58UCuTYGig+9GNaW5YBilZruQO+g/T/HKGgb6FRTOta3xoWfoj/BiIBfN/DtLaFe4gzqZ2oHvcPLl9hxh/0tytg4aS+BH3A11fZT8w6HA7ASa4HCXDmlx7MeIuviIIdSHWDd7PhsxHrY8QSH4YDcK3T9j6EjpLR5/oGmgrqtxeI7CIa7yymwX8Dmj5suTumrgLcK8IfUXqJWQm/4gX6P20nEe8b4I4Zz0SAY4o/QCAFZTRy7AFgHQEPiosLwLFfB57zyiEkiFq2X2kWD0DafgHh6IR4GWAs8lCQq8bFAeCkEqCHJqs9iFHdEOROaKJRC7kyHfczPr6K8UtfsOfA73TZ9Sgvo0ztI6HELwxAxm5A2Qw8MfmWcfMOg5zL++51SzmAVO8IWvmpule2Axm7B6XJp8kjKEeJWe1zGYbKATjJVpBMSVEiB4jGD85FeOU74NjuXWfR+xzgA0zr8fmIr+wzMPtWL19rP1k9WOyqJAxU5UbIO0t5N3sbEW5DGQTpg1wfZqIvjMhStpUFKJfKEnGWARagyKVfZFdbwHzzL/kR+hcVZX1ArdQS3AAAAABJRU5ErkJggg==";	    
	    
	  document.querySelector(".home-btn img").src = "data:image/png;base64,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";
	  document.querySelector(".account-btn img").src = "data:image/png;base64,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";
	}else if(screen!='contact'){
	  isContactAvailable = "false";
	  document.querySelector(".search-btn p").innerHTML = "Search";
	  document.querySelector(".search-btn img").src = "data:image/png;base64,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";
	
	  document.querySelector(".home-btn img").src = "data:image/png;base64,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";
  	  document.querySelector(".account-btn img").src = "data:image/png;base64,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";
	}
}

home_btn.addEventListener("click", () => {
	setDisableAllBtns('');
	modifyURLs('home');
	home_container.classList.remove("hide_view");

	home_btn.classList.add("active-nav");
	search_btn.classList.remove("active-nav");
	account_btn.classList.remove("active-nav");

	document.querySelector(".home-btn img").src = "data:image/png;base64,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";
})

search_btn.addEventListener("click", () => {
    if(isContactAvailable=="true"){
      setDisableAllBtns('contact');
      let telegram_url = search_btn.getAttribute('data-val');
      let platform_type = input_platform_type.value;
      
      if (telegram_url!="") {
	    if (platform_type == "web") {
	       window.open(telegram_url, "_self");                     
	    }else{
	       Handle.linkOpenAction(telegram_url);
	    }
	  }
      
    }else{
      setDisableAllBtns('search');
      
      modifyURLs('search');
  	  search_container.classList.remove("hide_view");

	  home_btn.classList.remove("active-nav");
	  search_btn.classList.add("active-nav");
	  account_btn.classList.remove("active-nav");

	  document.querySelector(".search-btn img").src = "data:image/png;base64,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";
    }
})

account_btn.addEventListener("click", () => {
   setAccount();
})

function setAccount(){
 	setDisableAllBtns('account');
	modifyURLs('my');
	login_container.classList.remove("hide_view");

	home_btn.classList.remove("active-nav");
	search_btn.classList.remove("active-nav");
	account_btn.classList.add("active-nav");
	
	document.querySelector(".account-btn img").src = "data:image/png;base64,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";   
}

function loadExtraHtml(){
    let input_mobile_num = document.querySelector("#input-mobile-num");
    let input_password = document.querySelector("#input-password");
    let input_otp = document.querySelector("#input-otp");
    let send_otp_btn = document.querySelector(".send-otp-btn");
}

function showRegistration(){
    loadExtraHtml();
    setupRegistration();
    login_container.classList.add("hide_view");
    reset_container.classList.add("hide_view");
    register_container.classList.remove("hide_view");
    modifyURLs('register');
}

function showResetPassword(){
    setupResetPassword();
    login_container.classList.add("hide_view");
    register_container.classList.add("hide_view");
    reset_container.classList.remove("hide_view");
    modifyURLs('forgotpass');
}

function gotoLogin(){
    setupLogin();
    login_container.classList.remove("hide_view");
    reset_container.classList.add("hide_view");
    register_container.classList.add("hide_view"); 
}

function downloadAPK(url) {
    const a = document.createElement('a')
    a.href = url
    a.download = url.split('/').pop()
    document.body.appendChild(a)
    a.click()
    document.body.removeChild(a)
}

let refer_code = input_refer_code.value;

if(refer_code!=""){
    setAccount();
    showRegistration();
}

if(input_api_target.value!=""){
    apiTargetURL = input_api_target.value;
}else{
    showToast('Something went wrong!');  
}

gotoLogin();
modifyURLs('login');