let apiTargetURL = "",
  INPUT_GIFT_CODE = "";

let input_api_target = document.querySelector("#input_api_target");
let input_giftcode = document.querySelector("#env_code");
let apply_envelop_btn = document.querySelector(".sup_claim_btn");

function goBackPage() {
  history.back();
}
const token = localStorage.getItem("USER-SESSION");
if (!token) {
  window.location.href = "/";
}
apply_envelop_btn.addEventListener("click", () => {
  requestApplyEnvelop(localStorage.getItem("USER-SESSION"));
});

function requestApplyEnvelop(user_id) {
  async function requestFile(gift_code, user_id) {
    try {
      const response = await fetch(
        apiTargetURL +
          "claim_envelop.php?USER_ID=" +
          user_id +
          "&ENVELOP_ID=" +
          gift_code,
        {
          method: "GET",
        }
      );

      const resp = await response.json();
      // console.log(resp);
      if (resp.status_code == "success") {
        input_giftcode.value = "";
        showPopUpDialog(
          "Envelope Applied!",
          "Envelope Applied successfully.",
          "success-dialog"
        );
      } else if (resp.status_code == "claimed") {
        showPopUpDialog(
          "Already Applied!",
          "Oops! You've already applied this Envelope.",
          "rejected"
        );
      } else if (resp.status_code == "code_not_exist") {
        showPopUpDialog(
          "Envelope Not Exist!",
          "Oops! You've entered invalid Envelope.",
          "rejected"
        );
      } else if (resp.status_code == "unauthorized") {
        showPopUpDialog(
          "You are Unauthorized User!",
          "Please Login To Claim Reward",
          "rejected"
        );
      } else if (resp.status_code == "recharge") {
        showPopUpDialog(
          "You are not eligible!",
          "Recharge First To Claim Reward",
          "rejected"
        );
      } else {
        showPopUpDialog(
          "Something went Wrong!",
          "Oops! We failed to connect with server.",
          "rejected"
        );
      }

      dismissLoadingDialog();
    } catch (error) {
      dismissLoadingDialog();
    }
  }

  apiTargetURL = input_api_target.value;
  INPUT_GIFT_CODE = input_giftcode.value;

  if (INPUT_GIFT_CODE != "" && apiTargetURL != "" && user_id != "") {
    if (INPUT_GIFT_CODE.length < 5) {
      showToast("Invalid Envelope Code!");
    } else {
      showLoadingDialog();
      requestFile(INPUT_GIFT_CODE, user_id);
    }
  } else {
    showToast("INVALID CODE");
  }
}

function modifyURLs(screen) {
  const stateData = {
    message: "New state!",
  };

  let newUrlIS = window.location.origin + "/#/" + screen;
  history.replaceState(stateData, null, newUrlIS);
}

modifyURLs("getredenvelope");