jQuery(document).ready(function(){
	
	jQuery("[data-macro]")
	.attr("id",function(arr){return 'macro'+arr;})
	.each(function(index){
//		jQuery.ajax({
//	        type:"GET",
//	        url: "/"+this.dataset.pmlpath+".pml",
//	        success: handleRecieve,
//	        error: handleError,
//	        data: {name:this.dataset.macro, slug:this.dataset.slug, isMacroRequest:true},
//	        dataType: "html",
//	        target:jQuery(this).attr('id')
//	    });
		
		if(this.dataset.macro==="form"){
			formMacroSend(this);
		}
		if(this.dataset.macro==="syncontent"){
			syncontentSend(this);
		}
	});
	
});


function syncontentSend(me){
	var el = jQuery(me);
	var id = el.attr('id');
	var int = id.substring(5);
	var ignorejs = el.attr('data-ignorejs');
	console.log('ignorejs: ' + ignorejs);

	// solves a very strange bug where spaces in "Companion Animal" somehow broke it with a carriage return and multiple spaces. It was even marshalled correctly, so I don't understand what happened.
	var topics = me.dataset.topics.replace(/[\n\r]/g, '').replace(/ +/g,' '); 

	jQuery.ajax({
        type:"GET",
        url: "/"+me.dataset.pmlpath+".pml",
        success: handleRecieve,
        error: handleError,
        data: {name:me.dataset.macro, slug:me.dataset.slug, ignorejs: ignorejs, isMacroRequest:true, macroPos:int, topics:topics, articleCount:me.dataset.articlecount || 6 , maxCharacters:me.dataset.maxcharacters},
        dataType: "html",
        target:jQuery(me).attr('id')
    });
}


function formMacroSend(me){
	var id = jQuery(me).attr('id');
	var int = id.substring(5);
	
	jQuery.ajax({
        type:"GET",
        url: "/"+me.dataset.pmlpath+".pml",
        success: handleRecieve,
        error: handleError,
        data: {name:me.dataset.macro, slug:me.dataset.slug, isMacroRequest:true,macroPos:int},
        dataType: "html",
        target:jQuery(me).attr('id')
    });
}

function htmlDecode(input){
  var e = document.createElement('div');
  e.innerHTML = input;
  return e.childNodes.length === 0 ? "" : e.childNodes[0].nodeValue;
}

function handleRecieve(data){
	jQuery('#'+this.target).html(data);
}
function handleError(xhr, ajaxOptions, thrownError){
//	alert("boo.");
}

function formValidateSubmitAndRedraw(slug,command){
	
	var formData = jQuery("#form-"+slug).serialize();
	
	jQuery.ajax({
		type:"POST",
//		url:"/"+slug+".pml",
//		url: "/macroFormViewBean.pml",		
		url: "/"+command+".pml",
		data: formData,
		dataType: "json",
		success: function(data){
			if(data.errors.length > 0){
				if(data.verificationUrl && data.verificationToken){
					jQuery('input[name="verificationToken"]').val(data.verificationToken);
					jQuery('#verificationCaptcha').attr({"src":data.verificationUrl});
				}
				
				var div = document.createElement("div");
				jQuery(div).attr({"id":"errorDiv"});
				for(var i = 0; i < data.errors.length; i++){
					var dat = data.errors[i];
					for (var key in dat){
						jQuery(div).append('<p><img style="height:20px" src="/images/html/common/images/icons/close_32.gif">: '+dat[key]+'</p>');
					}
				}
				
				if(jQuery("#errorDiv").length == 0){
					jQuery(this.target).prepend(div);
				}else{
					jQuery("#errorDiv").html(jQuery(div).html());
				}
				
			}else if (data.successMsg){
				jQuery(this.target).replaceWith('<p>'+htmlDecode(data.successMsg)+'</p>');
			}else{
				jQuery(this.target).replaceWith('<p>There may have been an error.</p>');
			}
		},
		error: function(xhr, ajaxOptions, thrownError){
			jQuery(this.target).replaceWith('<p>There may have been an error.</p>');
		},
		target:"#form-"+slug
	});
}