var VINFooter = Class.create(
    {
        initialize: function(options) {
            this.getFooterSuccess=this.getFooterSuccess.bind(this);
            this.IsPublic=null;
            this.UrlRoot="";
            this.ContactHref="";
            this.ContactText="";
            this.ElementId="";
            this.ShowVINDEX=true;
            Object.extend(this,options || {});
            if (this.ElementId) this.getFooter();
        },
        getFooter: function(id) {
            if (id) this.ElementId = id;
            var url = '/AppUtil/VINControlRenderer.aspx?ControlName=Footer'; 
        
            var bodyParams = { };
            if (this.IsPublic != null) bodyParams.IsPublic = this.IsPublic;
            if (this.UrlRoot) bodyParams.UrlRoot = this.UrlRoot;
            if (this.ContactHref) bodyParams.ContactHref = escape(this.ContactHref);
            if (this.ContactText) bodyParams.ContactText = this.ContactText;
            if (this.ShowFeedback) bodyParams.ShowFeedback = this.ShowFeedback;
            if (this.ShowHelp) bodyParams.ShowHelp = this.ShowHelp;
            if (this.ShowMobile) bodyParams.ShowMobile = this.ShowMobile;
            if (this.ShowMyActivities) bodyParams.ShowMyActivities = this.ShowMyActivities;
            if (this.ShowVINDEX) bodyParams.ShowVINDEX = this.ShowVINDEX;

            new Ajax.Request(url, {
                method: 'post',
                postBody: Object.toQueryString(bodyParams),
                onSuccess: this.getFooterSuccess } );
        },
        getFooterSuccess: function(response) {
            if (!response.responseText)
                return;
                
	        var res = response.responseText;
            $(this.ElementId).innerHTML = unescape(res);
            //res.evalScripts();
        }
    }
);


var VINToolBar = Class.create(
    {
        initialize: function(options) {
            this.getToolbarSuccess=this.getToolbarSuccess.bind(this);
            this.IsPublic=null;
            this.UrlRoot="";
            this.BreadCrumbHtml="";
            this.BreadCrumbRootUrl="";
            this.BreadCrumbRootText="";
            this.BookMarkAltTest="";
            this.BookMarkUrl=null;
            this.EmailMeRoot=null;
            this.EmailMeUrl=location.href;
            this.PrintUrl=null;
            this.PrintJSFunction=null;
            this.IncludeRSSFeed=null;
            this.RSSFeedLink="";
            this.ShowBack=null;
            this.ShowPrintPage=null;
            this.ShowSavePage=null;
            this.ShowBookmark=null;
            this.ShowEmailMe=null;
            this.ShowUp=null;
            this.ShowQuickSearch=null;
            this.ElementId="";            
            Object.extend(this,options || {});
            if (this.ElementId) this.getToolbar();
        },
        getToolbar: function(id) {
            if (id) this.ElementId = id;
            var url = '/AppUtil/VINControlRenderer.aspx?ControlName=BreadCrumbToolBar'; 

            var bodyParams = { };
            if (this.IsPublic != null) bodyParams.IsPublic = this.IsPublic;
            if (this.UrlRoot) bodyParams.UrlRoot = this.UrlRoot;
            if (this.BreadCrumbHtml) bodyParams.BreadCrumbHtml = escape(this.BreadCrumbHtml);
            if (this.BreadCrumbRootUrl) bodyParams.BreadCrumbRootUrl = this.BreadCrumbRootUrl;
            if (this.BreadCrumbRootText) bodyParams.BreadCrumbRootText = this.BreadCrumbRootText;
            if (this.BookMarkUrl) bodyParams.BookMarkUrl = escape(this.BookMarkUrl);
            if (this.BookMarkAltTest) bodyParams.BookMarkAltTest = this.BookMarkAltTest;
            if (this.EmailMeRoot != null) bodyParams.EmailMeRoot = this.EmailMeRoot;
            if (this.EmailMeUrl) bodyParams.EmailMeUrl = this.EmailMeUrl;
            if (this.PrintUrl) bodyParams.PrintUrl = this.PrintUrl;
            if (this.PrintJSFunction) bodyParams.PrintJSFunction = this.PrintJSFunction;
            if (this.IncludeRSSFeed != null) bodyParams.IncludeRSSFeed = this.IncludeRSSFeed;
            if (this.ShowBack != null) bodyParams.ShowBack = this.ShowBack;
            if (this.ShowPrintPage != null) bodyParams.ShowPrintPage = this.ShowPrintPage;
            if (this.ShowSavePage != null) bodyParams.ShowSavePage = this.ShowSavePage;
            if (this.ShowBookmark != null) bodyParams.ShowBookmark = this.ShowBookmark;
            if (this.ShowEmailMe != null) bodyParams.ShowEmailMe = this.ShowEmailMe;
            if (this.ShowUp != null) bodyParams.ShowUp = this.ShowUp;
            if (this.ShowQuickSearch != null) bodyParams.ShowQuickSearch = this.ShowQuickSearch;
            if (this.RSSFeedLink) bodyParams.RSSFeedLink = this.RSSFeedLink;
             
            new Ajax.Request(url, {
                method: 'post',
                postBody: Object.toQueryString(bodyParams),
                onSuccess: this.getToolbarSuccess } );
        },

        getToolbarSuccess: function(response) {            
            if (!response.responseText)
                return;
                
	        var res = response.responseText;
//            $(this.ElementId).innerHTML = unescape(res);	        

            $(this.ElementId).update(unescape(res));	        

			try {
	       InitQuickSearch();
			} catch(e) {}
	       FooterToolbar.initialize();
        }
    }
);

var VINMenu = Class.create(
    {
        initialize: function(options) {
            this.getMenuSuccess=this.getMenuSuccess.bind(this);
			this.HighlightedItem="";
            this.ElementId="";
            Object.extend(this,options || {});
            if (this.ElementId) this.getMenu();
        },
        getMenu: function(id) {
            if (id) this.ElementId = id;
            var url = '/AppUtil/VINControlRenderer.aspx?ControlName=VINNavigationBar'; 

			var bodyParams = { };
            if (this.HighlightedItem != null) bodyParams.HighlightedItem = this.HighlightedItem;

            new Ajax.Request(url, {
                method: 'post',
                postBody: Object.toQueryString(bodyParams),
                onSuccess: this.getMenuSuccess } );
        },
        getMenuSuccess: function(response) {
            if (!response.responseText)
                return;
                
	    var res = response.responseText;
            $(this.ElementId).innerHTML = unescape(res);
        }
    }
);

var VINSurvey = Class.create(
    {
        initialize: function(options) {
            this.getSurveySuccess=this.getSurveySuccess.bind(this);
            this.TestId="";
            this.ForceResults="false";
            this.ElementId="";
            Object.extend(this,options || {});
            if (this.ElementId) this.getSurvey();
        },
        getSurvey: function(id) {
            if (id) this.ElementId = id;
            var url = '/AppUtil/VINControlRenderer.aspx?ControlName=SmallSurveyDotNetBased'; 

            var bodyParams = { };
            if (this.TestId != null) bodyParams.TestId = this.TestId;
            if (this.ForceResults != null) bodyParams.ForceResults = this.ForceResults;

            new Ajax.Request(url, {
                method: 'post',
                postBody: Object.toQueryString(bodyParams),
                onSuccess: this.getSurveySuccess } );
        },
        getSurveySuccess: function(response) {
            if (!response.responseText)
                return;
                
	    var res = response.responseText;
            $(this.ElementId).innerHTML = unescape(res);
        }
    }
);

var VINLogout = Class.create(
    {
        initialize: function(options) {
            this.getLogoutSuccess = this.getLogoutSuccess.bind(this);
            this.ElementId = "";
            Object.extend(this, options || {});
            if (this.ElementId) this.getLogout();
        },
        getLogout: function(id) {
            if (id) this.ElementId = id;
            var url = '/AppUtil/VINControlRenderer.aspx?ControlName=MemberLogout';

            new Ajax.Request(url, {
                method: 'post',
                onSuccess: this.getLogoutSuccess
            });
        },
        getLogoutSuccess: function(response) {
            if (!response.responseText)
                return;

            var res = response.responseText;
            $(this.ElementId).update(unescape(res));
        }
    }
);