// *********************************************************
// VIN.js is copyrighted Veterinary Information Network 2004
// *********************************************************



var agt = navigator.userAgent.toUpperCase();
var BrowserVersion = parseInt(navigator.appVersion);
if (agt.indexOf('MSIE 5')) BrowserVersion = 5;
var IsMac = ((agt.indexOf('MAC_') != -1) || (agt.indexOf('MACINTOSH') != -1));
var IsAOL = (agt.indexOf('AOL') != -1);
var IsIE = (navigator.appName.indexOf('Microsoft') != -1);
var IsNS = (navigator.appName.indexOf('Netscape') != -1);
var IsNS4 = (IsNS && (BrowserVersion >= 4));
var IsIE4 = (IsIE && (BrowserVersion >= 4));
var IsIE5 = (IsIE && (BrowserVersion >= 5));
var IsDOM = (BrowserVersion >= 5);

var CtrlTxt = (IsMac) ? 'Command' : 'CTRL';
var FavoriteTxt = (IsIE) ? 'Favorite' : 'Bookmark';

var Months = new Array('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
var Days = new Array('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');
var CurDate = new Date();
var WeekDay = CurDate.getDay();
var Day = CurDate.getDate();
var Month = CurDate.getMonth();
var Year = CurDate.getYear();
Year = (Year < 1900) ? Year + 1900 : Year;

var VINDocumentID = 0;
var MyMemberId = 0;

if (document.getElementsByTagName("head") && typeof (bSkipContext) == "undefined")
{
    document.write("<scr" + "ipt type='text/javascript' src='/global/js/contextmenu.js'></scr" + "ipt>");
    document.write("<scr" + "ipt type='text/javascript' src='/global/js/vinfooter.js'></scr" + "ipt>");
}

// Let's see if the page has any video elements
(
    function () {
        try {
            function getQueryStringObject(qs) {
                //parse the querystring into an object of key value pairs.  question mark is required to indicate start of QS portion
                var ret = {};
                if (typeof qs === "string" && qs.length > 1 && qs.indexOf("?") > -1) {
                    var qsStr = qs.split("?")[1];
                    var qsA = qsStr.split("&");
                    var qsO = {};

                    for (var i = 0; i < qsA.length; i++) {
                        var obj = qsA[i].split("=");
                        if (obj.length === 2) {
                            qsO[obj[0].toLowerCase()] = obj[1];
                        } else if (obj.length === 1) {
                            qsO[obj[0].toLowerCase()] = "";
                        }
                    }
                    ret = qsO;
                }
                return ret;
            };
            var loopVars = { wait_duration: 100, loop_count: 0, script_added: false };
            function initVideoJS(e) {
                var videos = document.getElementsByTagName("video");
                if (!!videos && videos.length > 0) {
                    if (typeof (videojs) != 'undefined') {
                        for (var i = 0; i < videos.length; i++) {
                            // that don't already have the Video.js CSS class
                            if (!videos.item(i).classList.contains('video-js')
                                && !videos.item(i).hasAttribute('data-vin-video-ignore')) {
                                var videoSource = videos.item(i).src.toLowerCase().trim();

                                if (videoSource.indexOf('/members/viewer/viewer.ashx') > -1) {
                                    var vidQs = getQueryStringObject(videoSource);

                                    if (!!vidQs.hasOwnProperty && vidQs.hasOwnProperty('documentid')) {
                                        var documentId = vidQs['documentid'];
                                        var videoId = 'vid' + documentId;
                                        var poster = '/members/viewer/viewer.ashx?DocumentId=' + documentId + '&FileTypeId=11';
                                        videos.item(i).id = videoId;
                                        if (videos.item(i).poster.length === 0) {
                                            videos.item(i).poster = poster;
                                        }
                                    }
                                }
                                videos.item(i).classList.add('video-js');
                                videos.item(i).classList.add('vjs-default-skin');
                                videos.item(i).removeAttribute('role');
                                videos.item(i).removeAttribute('tab-index');
                                if (!videos.item(i).querySelector('source')) {
                                    var newSourceNode = document.createElement('source');
                                    let sourceNode = videos.item(i).appendChild(newSourceNode);
                                    sourceNode.src = videoSource;
                                    sourceNode.type = 'video/mp4'
                                } else {
                                    let sourceNode = videos[i].querySelector('source');
                                    if (sourceNode.type.length < 1) {
                                        sourceNode.type = 'video/mp4';
                                    }
                                }
                                videojs(videos.item(i), {
                                    "controls": true,
                                    "autoplay": false,
                                    "preload": 'metadata',
                                    "playbackRates": [2.5, 2.25, 2, 1.75, 1.5, 1.25, 1, 0.5, 0.25]
                                }, (function (video) {
                                    return function () {
                                        var correct_size = function (e) {
                                            var vid = e.target;
                                            var ch = vid.clientHeight;
                                            var cw = vid.clientWidth;
                                            var vh = vid.videoHeight;
                                            var vw = vid.videoWidth;
                                            var ratioWidth = cw / vw;
                                            var ratioHeight = ch / vh;
                                            var minimumRatio = Math.min(ratioWidth, ratioHeight);
                                            var nw = minimumRatio * vw;
                                            var nh = minimumRatio * vh;
                                            var vid_parent = vid.parentNode;
                                            vid_parent.style.width = nw + 'px';
                                            vid_parent.style.height = nh + 'px';
                                            vid_parent.style.minWidth = '450px';

                                            var doc_id = GetVideoDocID(vid);
                                            jQuery.ajax({
                                                url:'/c/videoinfo/' + doc_id,
                                                context:vid_parent,
                                                success: function(data){
                                                    if(!!data.data && !!data.data.can_download && !!data.data.download && !!data.data.download.url){
                                                        var down_link = document.createElement('a');
                                                        down_link.setAttribute('href',data.data.download.url );
                                                        down_link.setAttribute('download','');
                                                        down_link.text = 'Download Video';
                                                        this.after(down_link)
                                                    }
                                                    
                                                }
                                            })
                                            
                                        };
                                        if (video.readyState == 0) {
                                            video.addEventListener("loadedmetadata", correct_size);
                                        } else {
                                            setTimeout(function () { correct_size({ target: video }) }, 1);
                                        }
                                        video.addEventListener("loadedmetadata", correct_size);

                                        video.style = '';
                                        //hack to accomodate large list of playback rates

                                        var menus = document.getElementsByClassName('vjs-menu-content');
                                        for (var i = 0; i < menus.length; i++) {
                                            menus[i].style.overflow = "hidden";
                                            menus[i].style.overflowY = "auto";

                                        }

                                    }
                                })(videos.item(i)));

                            }
                        }
                    } else {
                        //if video js isn't loaded add reference and loop over to wait to ensure load

                        if (loopVars.loop_count > 50) {
                            return;
                        }
                        loopVars.loop_count++;

                        if (!loopVars.script_added && typeof (jQuery) != 'undefined') {
                            //if jquery exists on page load video JS library and re-run video initialization  

                            jQuery('head').append(jQuery('<link rel="stylesheet" type="text/css" />').attr('href', 'video-js/video-js.css'));
                            jQuery.getScript('../ext_iframe/Global/JS/video-js/video.js', initVideoJS);
                            loopVars.script_added = true;
                        } else {
                            // wait duration is an increasing value to acomodate fast and slow connections and processing time
                            setTimeout(initVideoJS, loopVars.wait_duration);
                            //create and increasing timeout wait duration to accomodate slow connections and computers
                            loopVars.wait_duration *= 1.5;
                            loopVars.wait_duration = Math.floor(loopVars.wait_duration);
                        }


                    }
                }
            }
            document.addEventListener("DOMContentLoaded", initVideoJS);
            var GetVideoDocID = function (vid) {
                try {
                    var vidDocId = 0;
                     if (vid.hasAttribute('documentid')) {
                        vidDocId = vid.getAttribute('documentid');
                    } else if (vid.hasAttribute('fileid')) {
                        vidDocId = vid.getAttribute('fileid');
                    } else if (vid.hasAttribute('imageid')) {
                        vidDocId = vid.getAttribute('imageid');
                    } else if(vid.hasAttribute('src')){
                        let vid_url = vid.getAttribute('src').toLowerCase();
                        if (vid_url.indexOf('viewer.ashx')>-1){
                            var vid_qs = getQueryStringObject(vid_url);
                            vidDocId = vid_qs.documentid;
                        }else if (vid_url.indexOf('/c/video/')>-1){
                            var vid_path = vid_url.split('?')[0];
                            var path_parts = vid_path.split('/');
                            vidDocId = path_parts.slice(-1)[0];
                        }else if(vid_url.indexOf('?')>-1){
                            var vid_qs = getQueryStringObject(vid_url);
                            if(!!vid_qs.documentid){
                                vidDocId = vid_qs.documentid;
                            }else if(!!vid_qs.docid){
                                vidDocId = vid_qs.docid;
                            }
                        }
                    }
                } catch (e) {
                    console.error('error getting video document id', e);
                } finally {
                    return vidDocId;
                }
            }
            

        } catch (e) {
            console.error('Error loading videoJS player on page', e)
        }
    }
)();

function deferVidCheck () {
    if(window.jQuery){
        try{
            jQuery(function(){
                jQuery('body').on('contextmenu','video',function (e) { e.preventDefault(); return false });
            })
        }catch(e){
            console.error(e);
        }
    } else {
        setTimeout(deferVidCheck, 50);
    }
}
deferVidCheck();

function domScriptInsert(filename)
{
    var scriptInsert = document.createElement('script');
    scriptInsert.setAttribute('language', 'javascript');
    scriptInsert.setAttribute('type', 'text/javascript');
    scriptInsert.setAttribute('src', filename);
    return scriptInsert;
}

// Added 7/17/07 PM... trims a string of blank spaces.
function trim(s)
{

    var str = s;
    try
    {
        str = s.replace(/^\s*/, "").replace(/\s*$/, "");
    } catch (e) { }
    return str;
}

function isArray(variable)
{
    return (variable.constructor == Array);
}

function GetWindowSize()
{
    var windowWidth = 0,
        windowHeight = 0;
    if (typeof (window.innerWidth) == 'number')
    {
        windowWidth = window.innerWidth;
        windowHeight = window.innerHeight;
    } else if (document.documentElement && (document.documentElement.clientWidth || document.documentElement.clientHeight))
    {
        windowWidth = document.documentElement.clientWidth;
        windowHeight = document.documentElement.clientHeight;
    } else if (document.body && (document.body.clientWidth || document.body.clientHeight))
    {
        windowWidth = document.body.clientWidth;
        windowHeight = document.body.clientHeight;
    }
    return [windowWidth, windowHeight];
}

function CleanDocTitle(Title)
{
    if (window.RegExp)
    {
        var rExp = /[\\\/\:\*\?\"\|\<\>]/g;
        Title = Title.replace(rExp, " ")
        rExp = /  +/g;
        Title = Title.replace(rExp, " ")
    }
    return (Title);
}

function PrintPage(printUrl)
{
	try {
		ActivityMonitor.OnPrintAfter();
	} catch (e) {
		console.log("ActivityMonitor.OnPrintAfter error" + e);
	}	
    if (printUrl && printUrl.length > 0)
    {
        window.open(printUrl);
        return;
    }
    if (window.print)
        window.print();
    else
        alert('You may print this page using ' + CtrlTxt + '-P.');
}

function SavePage()
{
    if (IsIE4 && !IsMac) document.execCommand('SaveAs', true, CleanDocTitle(document.title));
    else alert('You may save this page by selecting the Save As option from the File menu.');
}

function BackPage()
{
    history.back();
}

function BookmarkPage(ForceURL, NameIn) {
    var URL = (ForceURL) ? ForceURL : window.location.href;
    if (URL.toUpperCase().indexOf('/VINMEMBERS/TOOLKIT') != -1 && typeof VINToolkit.GetActiveUrl === "function") {
        var strUrl = VINToolkit.GetActiveUrl();
        if (strUrl.length !== 0) {
            URL = strUrl;
            NameIn = VINToolkit.GetActiveTitle();
        }
    }
    // We need to search for and replace "&#" with "#". There are times when we have the start of a name/value query string pair
    // (indicated by the ampersand), but no name/value query string pair. If this happens to be followed up with an anchor
    // link, then no amount of encoding is going to prevent ASP.NET from puking on the &# because it will think this is dangerious
    // (short of disabling request validation for the page in question).
    // Example: /members/cms/project/defaultadv1.aspx?id=6407820&pid=8993&catid=1&#myimage
    URL = URL.replace("&#", "#");
    if ((
        URL.toUpperCase().indexOf('MEMBERS/') != -1         
        || URL.toUpperCase().indexOf('NEWS.VIN.COM/') != -1         
        || URL.toUpperCase().indexOf('/ADMIN/') != -1
        || URL.toUpperCase().indexOf('/C/VIDEOPROCEDURES') != -1
        || URL.toUpperCase().indexOf('STUDENTDEBTCENTER/') != -1
        //|| URL.toUpperCase().indexOf('APPUTIL/') != -1 //uncomment for testing ISLE on localhost
    ) && URL.toUpperCase().indexOf('MEMBERS/VSPN/') == -1) {
        var DocTitle = (NameIn) ? NameIn : document.title;
        var DocumentID = (VINDocumentID) ? '&DID=' + VINDocumentID : '';
        var rpl = "&skipmaster=true";
        var pattern = new RegExp(rpl, 'gi');
        URL = URL.replace(pattern, '');
        ShowMyVIN('MyStuff&p=AddLinkFromURL&URL=' + escape(URL) + DocumentID + '&NameIn=' + escape(CleanDocTitle(DocTitle)));
    } else {
        if (IsAOL) alert('Please click the red heart to favorite this page.');
        else if (IsIE4 && !IsMac) window.external.AddFavorite(URL, CleanDocTitle(document.title));
        else alert('You may ' + FavoriteTxt + ' this page using ' + CtrlTxt + '-D.');
    }
}

function GetCenterPos(BWidth, BHeight)
{
    var PosX = (screen.availWidth - 10) / 2 - BWidth / 2;
    var PosY = (screen.availHeight - 30) / 2 - BHeight / 2;
    return ('width=' + BWidth + ',height=' + BHeight + ',left=' + PosX + ',top=' + PosY);
}

function GetIndexingFormXY(BWidth, BHeight)
{
    var PosX = 10;
    var PosY = 10;
    return ('width=' + BWidth + ',height=' + BHeight + ',left=' + PosX + ',top=' + PosY);
}

function ShowSizedWindow(URL, Width, Height, WndName)
{
    if (!WndName) WndName = '_blank'
    var args = 'width=' + Width + ',height=' + Height + ',menubar=no,status=no,location=no,directories=no,toolbar=no';
    window.open(URL, WndName, args);
}

function OpenNewWindow(URL, Width, Height)
{
    var args = 'menubar=no,status=no,location=no,directories=no,toolbar=no,scrollbars=yes,resizable=yes';
    if (Width && Height) args = 'width=' + Width + ',height=' + Height + ',' + args;
    window.open(URL, '_blank', args);
}

function InteractiveLearningWindow(Url, winName)
{
    //alert("InteractiveLearningWindow() called");
    var args = 'resizable=yes,width=1014,height=713';
    var argsIE6 = 'resizable=no,width=800,height=600';
    //alert("isIE: "+navigator.appVersion.charAt(22));
    var versionNum = navigator.appVersion.charAt(22);
    var ilWin;
    if (versionNum == 6)
    {
        ilWin = window.open(Url, winName, argsIE6);
    } else
    {
        ilWin = window.open(Url, winName, args);
    }
    if (!Prototype.Browser.Mobile) ilWin.focus();
}

function OpenNewBrowser(URL, Width, Height)
{
    var args = '';
    if (Width && Height) args = 'scrollbars=yes,resizable=yes,width=' + Width + ',height=' + Height;
    window.open(URL, '_blank', args);
}

function ShowPicture(ImgPath, ImgWidth, ImgHeight, Branding)
{
    var ScrollBar = "no";
    ImgWidth += 20;
    ImgHeight += 50;
    if (Branding == 1 || Branding == 9) ImgHeight += 10;
    if ((ImgWidth - 20) > screen.availWidth)
    {
        ImgWidth = screen.availWidth - 20;
        ScrollBar = "yes";
    }
    if ((ImgHeight - 40) > screen.availHeight)
    {
        ImgHeight = screen.availHeight - 40;
        ScrollBar = "yes";
    }

    var html = PictureHtml("Image Popup",ImgPath);
    if (Branding) URL += '&B=' + Branding;
    if (!Branding && ImgWidth < 335) ImgWidth = 335;
    if (Branding == 1 && ImgWidth < 410) ImgWidth = 410;
    if (Branding == 7 && ImgWidth < 385) ImgWidth = 385;
    var args = GetCenterPos(ImgWidth, ImgHeight) + ",menubar=no,status=no,location=no,directories=no,toolbar=no,scrollbars=" + ScrollBar + ",resizable=" + ScrollBar;
    var win = window.open("", "", args);
    win.document.write(html);
    win.document.close();
    
}

function OpenViewer(XML, OptionArray)
{

    var p3w;
    var p3h;

    p3w = document.viewport.getDimensions().width - (Math.floor(document.viewport.getDimensions().width * 0.10));
    p3h = document.viewport.getDimensions().height - (Math.floor(document.viewport.getDimensions().height * 0.10));

    //var args = GetCenterPos(445, 545)+',menubar=no,status=no,location=no,directories=no,toolbar=no,scrollbars=no,resizable=yes';
    var args = GetCenterPos(p3w, p3h) + ',menubar=no,status=no,location=no,directories=no,toolbar=no,scrollbars=no,resizable=yes';
    var URL = '/Presenter/Shell.aspx?viaScript=1&xmlPath=' + escape(XML);
    if (window.location.href.toUpperCase().indexOf('/MEMBERS/') != -1) URL = "/Members" + URL;
    if (OptionArray)
    {
        if (OptionArray['Branding']) URL += '&branding=' + OptionArray['Branding'];
        if (OptionArray['StartSlide']) URL += '&initSlide=' + OptionArray['StartSlide'];
        if (OptionArray['Subset']) URL += '&subset=' + OptionArray['Subset'];
        if (OptionArray['StartedFrom']) URL += '&startedFrom=' + OptionArray['StartedFrom'];
    }
    window.open(URL, 'MMViewer', args);
}

function OpenViewerFull(XML, OptionArray)
{

    w = 800
    h = 600
    if (window.screen)
    {
        w = window.screen.availWidth;
        h = window.screen.availHeight;
    }

    var args = 'width=' + w + ',height=' + h + ',menubar=no,status=no,location=no,directories=no,toolbar=no,scrollbars=no,resizable=yes';
    var URL = '/Presenter/Shell.aspx?viaScript=1&xmlPath=' + escape(XML);
    if (window.location.href.toUpperCase().indexOf('/MEMBERS/') != -1) URL = "/Members" + URL;
    if (OptionArray)
    {
        if (OptionArray['Branding']) URL += '&branding=' + OptionArray['Branding'];
        if (OptionArray['StartSlide']) URL += '&initSlide=' + OptionArray['StartSlide'];
        if (OptionArray['Subset']) URL += '&subset=' + OptionArray['Subset'];
        if (OptionArray['StartedFrom']) URL += '&startedFrom=' + OptionArray['StartedFrom'];
    }
    window.open(URL, 'MMViewer', args);
}

function ShowRemote()
{
    ShowMyVIN()
}

function ShowMyVSPN(Page)
{
    var URLValue = "/Members/Tools/MyVIN/Default.aspx";
    switch (Page)
    {
        case "BoardsPref":
            Page = "BoardsPreferences";
            break;
        case "GeneralPref":
            Page = "GeneralPreferences";
            break;
    }
    if (Page && Page.toLowerCase().lastIndexOf("profile&id=", 0) === 0)
    {
        Page = Page.toLowerCase().replace("profile&id=", "Profile&UniqueID=");
    }
    if (Page) URLValue += '?View=' + Page;
    var args = "top=1,width=770,height=630,menubar=no,status=no,location=no,directories=no,toolbar=no,scrollbars=yes,resizable=yes";
    try
    {
        var newWin = window.open(URLValue, "MyVIN", args);
        newWin.focus();
    } catch (ex)
    {
        alert("MyVIN failed to open. Please check if you have a pop-up blocker turned on and disable it or add an exception for this site to use MyVIN.");
    }
}

function ShowMyVIN(Page)
{
    var URLValue = "/Members/Tools/MyVIN/Default.aspx";
    switch (Page)
    {
        case "BoardsPref":
            Page = "BoardsPreferences";
            break;
        case "GeneralPref":
            Page = "GeneralPreferences";
            break;
    }
    if (Page && Page.toLowerCase().lastIndexOf("profile&id=", 0) === 0)
    {
        Page = Page.toLowerCase().replace("profile&id=", "Profile&UniqueID=");
    }
    if (Page) URLValue += '?View=' + Page;
    var args = GetCenterPos(1366, 768) + "top=1,menubar=no,status=no,location=no,directories=no,toolbar=no,scrollbars=yes,resizable=yes";
    try
    {
        var newWin = window.open(URLValue, "MyVIN", args);
        newWin.focus();

    } catch (ex)
    {
        alert("MyVIN failed to open. Please check if you have a pop-up blocker turned on and disable it or add an exception for this site to use MyVIN.");
    }
}

function ShowFeedback (EmailTo, Subject) {

    var loadFeedback = function () {
        $j.ajax({
            type: "GET",
            url: "/vinmembers/api/v1/mail/feedback?title=" + document.title.toString(),
            xhrFields: {
                withCredentials: true
            },
            dataType: "html",
            success: function (result) {
                if (typeof (BootstrapDialog !== 'undefined')) {
                    let $msg = $j('<div></div>');
                    $msg.append(result);
                    BootstrapDialog.show({
                        message: $msg,
                        width: 450,
                        height: 350,
                        title: "VIN Feedback - we want to hear from you!"
                    });
                }
                $j(setTimeout(function () {
                    $j('#feedback-form select').focus();
                }, 3000));
            },
            error: function (xhr, status, error) {
                console.log("Erorr with ShowFeedBack: ", error);
                alert('There has been an error; please contact support.');
            }
        })
    }

    $j.ajax({
        url: '/global/js/feedbackPost.js',
        dataType: 'script',
        success: function () { loadFeedback(); },
        async: true
    });
}

function ShowFeedbackLegacy(EmailTo, Subject) {

    //PM 11/10/11 - move to distribution list
    //if(EmailTo == "becky@vin.com") EmailTo = "paul@vin.com";

    var URLValue = "/Members/Help/FeedbackPopup.asp";
    var args = "width=370,height=400,menubar=no,status=no,location=no,directories=no,toolbar=no, scrollbars=yes";
    if (EmailTo || Subject) {
        URLValue += "?";
        if (EmailTo) URLValue += "EmailTo=" + EmailTo + "&";
        if (Subject) URLValue += "Subject=" + escape(Subject) + "&";
    }
    window.open(URLValue, "_blank", args);
}


function ShowFeedback4VINCE()
{
    var URLValue = "/Members/Help/FeedbackPopupCE.asp";
    var args = "width=370,height=370,menubar=no,status=no,location=no,directories=no,toolbar=no";
    window.open(URLValue, "_blank", args);
}

function ShowFeedback4VSPNCE()
{
    var URLValue = "/Members/VSPN/Templates/FeedbackPopupCE.asp";
    var args = "width=370,height=370,menubar=no,status=no,location=no,directories=no,toolbar=no";
    window.open(URLValue, "_blank", args);
}

function ShowUnityInstall(Room)
{
    var URLValue = "/VINChat/Steps.asp";
    if (Room) URLValue += '?Room=' + Room;
    var args = GetCenterPos(450, 300) + ",width=450,height=300,menubar=no,status=no,location=no,directories=no,toolbar=no,scrollbars=yes,resizable=yes";
    window.open(URLValue, "_blank", args);
}

function ShowClassroomModal(message)
{
    // who knows what other areas use this, try-catch for modal existence...if existing is real (o_O)
    try
    {
        document.getElementById('classroom-alert-message').innerHTML = CleanUpMessage(message);
        $j("#classroomModal").modal('show');
    }
    catch (e)
    {
        console.log(e);
        alert(message);
    }
    
}

function ShowClassroomModalWithData(message, data)
{
    // who knows what other areas use this, try-catch for modal to be or modal not to be, that is the question
    try
    {
        document.getElementById('classroom-alert-message').innerHTML = CleanUpMessage(message);
        var temp = document.getElementById('modal-classroom-link');
        temp.onclick = function () {
            LaunchClassroomZoom(data);
            return false;
        }
        $j("#classroomModal").modal('show');
    }
    catch (e)
    {
        console.log(e);
        alert(message);
    }
}

function LaunchClassroomZoom(dataCR){
    var crwindow = window.open(dataCR.url, 'tempzoomwindow');
    if (dataCR.hasOwnProperty('autoClose') && !dataCR.autoClose)
    {

    }
    else
    {
        var delay = 60000;
        if (dataCR.hasOwnProperty('autoCloseDelay'))
        {
            delay = dataCR.autoCloseDelay;
        }
        setTimeout(function ()
        {
            crwindow.close()
        }, delay);
    }
}

function CleanUpMessage(message){
    var str;
    str = message.replace(/(?:\r\n|\r|\n)/g,'<br/>');
    return str;
}

function LaunchUnity(Room, domain, classid, clickedelement)
{

    if (typeof __enddate != 'undefined' && __enddate > (new Date(1, 0, 1)))
    {
        var testDate = new Date();
        testDate.setDate(testDate.getDate());
        testDate = new Date(testDate.getFullYear(), testDate.getMonth(), testDate.getDate(), 23, 59, 000);
        if (testDate > __enddate)
        {
            ShowClassroomModal('Course is Closed!');
            return;
        }
    }

    switch (Room.toLowerCase())
    {
        case 'zoomwebinar':
        case 'zoommeeting':
            var currentTime = new Date();
            var data = {
                room: Room.toLowerCase(),
                classid: classid,
                time: currentTime
            };


            $j.ajax({
                url: '/a/z/v1/getlink',
                data: data,
                success: function (dataRet)
                {
                    RtsRoomLaunch(dataRet, clickedelement);
                },
                async: false
            });

            break;

        default:
            var PosX = screen.availWidth - 810;
            var PosY = 0;

            RoomName = Room.replace('-', '_'); //Steve added this, hyphens were breaking the open script.

            var unityUrl = '/Members/Unity3/Unity.plx?R=' + Room;

            if (classid != null && classid != '')
                unityUrl = unityUrl + "&ClassId=" + classid;

            if (domain != null && domain != '')
                unityUrl = domain + unityUrl;

            window.open(unityUrl, 'VINUnity_' + RoomName, 'left=' + PosX + ',top=' + PosY + ',width=800,height=550,menubar=no,status=no,location=no,directories=no,toolbar=no,scrollbars=no,resizable=yes');
    }


}

function RtsRoomLaunch(data, zoomlaunchelement)
{
    if (!data.hasOwnProperty('action'))
    {
        alert('An error has occurred please try again');
        return;

    };
    switch (data.action)
    {
        case 'linkChoice':
            if (!confirm(data.linkMessage))
            {
                return;
                break;
            }
        case 'link':
            if (data.hasOwnProperty('url'))
            {
                var subwindow = window.open(data.url, 'zoomtempwindow');
                var modalMessage = 'If zoom window doesn\'t open or it was closed, use this link:<br/>'+
                                       '<a href="javascript:void(0)" id="modal-classroom-link">Join Zoom session</a>';
                ShowClassroomModalWithData(modalMessage, data);
                if (subwindow == null)
                {
                    
                    try
                    {
                        zoomlaunchelement.href = data.url;
                        zoomlaunchelement.target = '_blank';
                        zoomlaunchelement.onclick = '';
                        zoomlaunchelement.removeAttribute('onclick');

                    } catch (e) { };
                    try
                    {
                        zoomlaunchelement = document.getElementById('CEClassRoom');
                        zoomlaunchelement.href = data.url;
                        zoomlaunchelement.target = '_blank';
                        zoomlaunchelement.onclick = '';
                        zoomlaunchelement.removeAttribute('onclick');

                    } catch (e) { };
                    try
                    {
                        zoomlaunchelement = document.getElementById('CEClassRoom2');
                        zoomlaunchelement.href = data.url;
                        zoomlaunchelement.target = '_blank';
                        zoomlaunchelement.onclick = '';
                        zoomlaunchelement.removeAttribute('onclick');

                    } catch (e) { };
                };
                if (data.hasOwnProperty('autoClose') && !data.autoClose) { } else
                {
                    var delay = 60000;
                    if (data.hasOwnProperty('autoCloseDelay'))
                    {
                        delay = data.autoCloseDelay;
                    }
                    setTimeout(function ()
                    {
                        subwindow.close()
                    }, delay);
                }
            } else
            {
                ShowClassroomModal('An error has occured please try again');
                return;
            }
            break;


            return;
            break;
        case 'inactive':
            if (data.hasOwnProperty('message'))
            {
                ShowClassroomModal(data.message);
            } else
            {
                ShowClassroomModal('The session has not started');
            }
            return;
            break;

        case 'notEnrolled':
            if (data.hasOwnProperty('message'))
            {
                ShowClassroomModal(data.message);
            } else
            {
                ShowClassroomModal('You are not enrolled in this course');
            }
            return;
            break;
        default:
            if (data.hasOwnProperty('message'))
            {
                ShowClassroomModal(data.message);
            } else
            {
                ShowClassroomModal('No active session');
            }
            return;

            break;
    }
}


function LaunchUnityOld(Room)
{
    var PosX = screen.availWidth - 810;
    var PosY = 0;
    RoomName = Room.replace('-', '_');
    window.open('/Members/Unity/Unity.plx?R=' + Room, 'VINUnity_' + RoomName, 'left=' + PosX + ',top=' + PosY + ',width=800,height=550,menubar=no,status=no,location=no,directories=no,toolbar=no,scrollbars=no,resizable=yes');
}

function SwapImg(Tab, ImgNo)
{
    if (Tab == '') return;
    if (Tab == CurrentTab && ImgNo == 1) ImgNo = 3;
    var TabSrc = eval('document.Tab' + Tab + '.src');
    var NewSrc = TabSrc.substring(0, TabSrc.indexOf('.gif') - 1) + ImgNo + '.gif';
    eval('document.Tab' + Tab + '.src = NewSrc');
}

function AsynchRequest()
{
    var _AjaxState = ['Uninitialized', 'Loading', 'Loaded', 'Interactive', 'Complete'];

    var _ReqObj = null;
    var _inProgress = false;
    var _isComplete = false;
    var _oThis = this;
    var _isSynchronus = false;

    this.METHOD = 'GET';

    var _CreateObj = function ()
    {
        if (window.XMLHttpRequest)
        {
            _ReqObj = new XMLHttpRequest();
        } else if (window.ActiveXObject)
        {
            try
            {
                _ReqObj = new ActiveXObject("Msxml2.XMLHTTP");
            } catch (e)
            {
                try
                {
                    _ReqObj = new ActiveXObject("Microsoft.XMLHTTP");
                } catch (e2) { }
            }
        }
        if (!_ReqObj) _oThis.OnError('Unable to create request.');
    }

    var _CallBack = function ()
    {
        var AjaxState = _AjaxState[_ReqObj.readyState];
        if (AjaxState == 'Complete')
        {
            try
            {
                var HTTPStatus = _ReqObj.status;
                if (HTTPStatus == 200)
                {
                    _inProgress = false;
                    _isComplete = true;
                    _oThis.OnComplete(_oThis);
                } else
                {
                    if (HTTPStatus == "500")
                    {
                        _oThis.OnError('Status: 500 - Your request has timed out. Please contact the system admin.');
                    } else
                        _oThis.OnError('Status: ' + HTTPStatus);
                }
            } catch (e)
            {
                //alert(e);
            }
        }
    }

    this.SetSynchFlag = function (boolFlag)
    {
        _isSynchronus = boolFlag;
    }

    this.GetSynchFlag = function ()
    {
        return _isSynchronus;
    }

    this.Send = function (URL, PostData)
    {
        _CreateObj();
        if (_inProgress && !_isComplete)
        {
            // Error
            alert('Already in progress');
        } else if (_ReqObj)
        {
            _inProgress = true;
            _isComplete = false;
            if (_isSynchronus)
                _ReqObj.open((PostData) ? 'POST' : 'GET', URL, false);
            else
                _ReqObj.open((PostData) ? 'POST' : 'GET', URL, true);

            _ReqObj.onreadystatechange = _CallBack;
            if (PostData) _ReqObj.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            try
            {
                _ReqObj.send(PostData);
            } catch (e) { } //alert(e); 
        }
    }

    this.GetResponseText = function ()
    {
        if (_ReqObj.responseText.indexOf('AuthDB.dll') == -1)
        {
            return _ReqObj.responseText;
        } else
        {
            var win = window.open("SecurityRedirect.aspx");
            return "AuthDB.dll";
        }
    }

    this.OnComplete = function (AsynchRequestObject)
    {
        //Needs to override
    }

    this.OnError = function (ErrorStr)
    {
        //Needs to override
        alert(ErrorStr);
    }
}

function moveCursorAtEnd(TB)
{
    if (TB.createTextRange)
    {
        var FieldRange = TB.createTextRange();
        FieldRange.moveStart('character', TB.value.length);
        FieldRange.collapse();
        FieldRange.select();
    }
}

function GetImageIndex(el)
{
    var retval = -1;
    for (var i = 0; i < document.images.length; i++)
    {
        var img = document.images[i];
        if (img.src.toLowerCase().indexOf("/image/handler.ashx") != -1)
        {
            retval++;
            if ((img.src == el.src) && (img.width == el.width)) break;
        }
    }
    return retval;
}

function GetImageCount()
{
    var retval = 0;
    for (var i = 0; i < document.images.length; i++)
        if (document.images[i].src.toLowerCase().indexOf("/image/handler.ashx") != -1)
            retval++;
    return retval;
}

function getTextSelection()
{
    var sel;
    if (window.getSelection)
    {
        sel = window.getSelection();
    } else if (document.getSelection)
    {
        sel = document.getSelection();
    } else if (document.selection)
    {
        //sel = document.selection;
        sel = document.selection.createRange().text;
    }
    return sel;
}

function DL(f) //download
{
    var usewindowopen = false;
    usewindowopen = (f.indexOf(".pdf") != -1);
    if (usewindowopen) window.open(f, "_blank");
    else location.href = f;
}
/*
if (0) {
  if (document.getElementsByTagName("head")) {
    var h = document.getElementsByTagName("head")[0];
    var lnk = document.createElement("link");
    lnk.setAttribute("rel", "stylesheet");
    lnk.setAttribute("media", "print");
    lnk.setAttribute("type", "text/css");
    if (screen.width<800) lnk.setAttribute("href", "../css/print800.css");
    else if (screen.width<1024) lnk.setAttribute("href", "../css/print1024.css");
    else if (screen.width<1152) lnk.setAttribute("href", "../css/print1152.css");
    else lnk.setAttribute("href", "../css/print1280.css");
    h.appendChild(lnk);
  }
}
*/
function ShowPolicies()
{
    var URLValue = "/Members/CE/Templates/Policies.htm";
    var args = "width=440,height=300,menubar=no,status=no,location=no,directories=no,toolbar=no,scrollbars=yes,resizable=yes";
    window.open(URLValue, "_blank", args);
}

var __STANDARD_POPUP_FEATURES__ = GetCenterPos(800, 650) + ",menubar=no,status=no,location=no,directories=no,toolbar=no,scrollbars=yes,resizable=yes";

var __INDEXING_POPUP_FEATURES__ = GetIndexingFormXY(1020, 650) + ",menubar=no,status=no,location=no,directories=no,toolbar=no,scrollbars=yes,resizable=yes";

function DoPermissionAdmin(pid)
{ // VINMainDomain is dropped automatically by VIN.Base.VINBasePage
    var url = 'https://' + VINMainDomain + '/admin/permission/asset.aspx?ItemID=' + pid;
    //var args = GetCenterPos(800,590)+',menubar=yes,status=yes,toolbar=no,resizable=yes,scrollbars=yes';
    window.open(url, '_blank', __STANDARD_POPUP_FEATURES__);
}

function DoIndexing(documentid)
{
    var windowname = "window" + documentid;
    var url = "/vinadmin/indexing?DocId=" + documentid;
    var x = window.open(url, windowname, __INDEXING_POPUP_FEATURES__);
    x.focus();
}

function DoHub(documentid)
{
    var windowname = "hubwindow" + documentid;
    var url = "/members/cms/hubby/hub.aspx?said=-1&docid=" + documentid;
    var x = window.open(url, windowname, __STANDARD_POPUP_FEATURES__);
    x.focus();
}

function DoSolrDoc(sserver, documentid)
{
	var solrurl = "http://" + sserver + "/solr/collection1/select?q=id:" + documentid;
    var windowname = "solrdoc" + documentid;
    var x = window.open(solrurl, windowname, __STANDARD_POPUP_FEATURES__);
    x.focus();
}

function EditDocument(url)
{
    var x = window.open(url, '_blank', __STANDARD_POPUP_FEATURES__);
    x.focus();
}

function QuickSearchGo()
{

    var k = document.getElementById('quicksearchtext');
    var d = document.getElementById('quicksearchdropdown');


    /* validation */
    if (!k.value || k.value == "Enter search terms...")
    {
        alert('Please enter search term(s)');
        return false;
    }

    /* GA */
    if (window.pageTracker) pageTracker._trackPageview('/quicksearch/go');

    var searchurl = "/members/search4/default.aspx?q=" + k.value;
    /* if (d.value == 1 || d.value == 2 || d.value == 3)
        searchurl += "&ST=1"
     else if (d.value == 4 || d.value == 7)
        searchurl += "&ST=3";	*/

    var x = window.open(searchurl, "", "");
    if (x == null)
    {
        alert('Your popup blocker is preventing us from showing the search page.');
        return;
    }
    x.focus();
}

function LoadDocumentVersion(docid, replacedocid, template)
{
    var features = GetCenterPos(525, 400) + ",menubar=no,status=no,location=no,directories=no,toolbar=no,scrollbars=yes,resizable=yes"
    var x = window.open("/members/cms/document/documentversion.aspx?template=" + encodeURIComponent(template) + "&id=" + docid + "&replacedocid=" + replacedocid, "docversion", features);
    x.focus();
}


function initializeHelp(documentId)
{
    //alert("initializing help doc [" + documentId + "]");	

}

function DocumentHit(documentId)
{
    var params = new Hash();
    params.set("documentId", documentId);
    new Ajax.Request('/members/webservices/documents/document.asmx/DocHit', {
        method: 'post',
        parameters: params.toQueryString(),
        onSuccess: function (transport)
        {
            window.status = "DH Success!";
        },
        onFailure: function (transport)
        {
            window.status = "DH Fail!";
        }
    });

}

function changePassword()
{
    OpenNewWindow('/vinmembers/account/changepassword', 600, 530);
}

function ViewAnnotation(url)
{
    var _p3w;
    var _p3h;
    _p3w = document.viewport.getDimensions().width - (Math.floor(document.viewport.getDimensions().width * 0.10));
    _p3h = document.viewport.getDimensions().height - (Math.floor(document.viewport.getDimensions().height * 0.10));
    OpenNewWindow(url, _p3w, _p3h);
}

function toggleCurrentSignature(id)
{
    var oldSig = document.getElementById("oldSignature" + id);
    var newSig = document.getElementById("myPopup" + id);

    var _oldSig = oldSig.innerHTML;
    var _newSig = newSig.innerHTML;

    $j("#oldSignature" + id).slideUp(2000, function ()
    {
        $j(this).html(_newSig).slideDown(2000).effect("highlight", {
            color: '#ff6600'
        }, 3000);
    });
    newSig.innerHTML = _oldSig;
}


/*  redirect document  */
function GoToDoc(projectid, docid)
{
    var url = window.location.pathname;
    var filename = url.substring(url.lastIndexOf('/') + 1);
    window.location.href = filename + "?pid=" + projectid + "&id=" + docid;
}


/* VINSessionHelper - used for determining if session is still alive */
var VINSessionHelper =
{
    endPoints:
    {
        sessionInfo:
        {
            datatype: 'json',
            url: '/vinmembers/api/security/sessioninfo',
            cache: false,
        }
    },
    publicUniqueId: 382614,
    quickRefresh: 30 * 1000, // int ms -> 30 seconds
    normalRefresh: 90 * 1000, // int ms -> 1.5 minutes
    sessionAlive: true,
    pollSessionInfo: function (context) 
    {
        jQuery
            .ajax(context.endPoints.sessionInfo)
            .done(function (data, status, xhr) { context.onRecieveSessionInfo(context, data); })
            .fail(function (xhr, status, error) { context.onError(context, error) })
        ;
    },
    onRecieveSessionInfo: function (context, sessionInfo)
    {
        console.debug("onRecieveSessionInfo: ", "alive: " + context.sessionAlive, sessionInfo);

        // If session is currently alive check how long we have left, and display notifications when it is less than certain thresholds.
        if (context.sessionAlive == true)
        {
            var minutesLeft = sessionInfo.result.timeLeft.totalMinutes;

            if (minutesLeft <= 0.0)
            {
                context.sessionAlive = false;
                console.info("VINSessionHelper: Session expired");

                noty({
                    text: "Your session has timed out.",
                    layout: "topCenter",
                    type: "error",
                    modal: true,
                    buttons:
                        [
                            {
                                addClass: 'btn btn-primary',
                                text: 'Refresh',
                                onClick: function ($noty)
                                {
                                    $noty.close();
                                    location.reload();
                                }
                            }
                        ]
                });

                setTimeout(function () { context.pollSessionInfo(context) }, context.quickRefresh);
                return;
            }

            if (minutesLeft <= 5.0)
            {
                console.info("VINSessionHelper: 5 minutes or less left.");
                noty({ text: "You have 5 minutes or less left on your session", layout: "topCenter", type: "information", timeout: 20 * 1000 });
                setTimeout(function () { context.pollSessionInfo(context) }, context.quickRefresh);
                return;
            }

            if (minutesLeft <= 30.0)
            {
                console.info("VINSessionHelper: 30 minutes or less left.");
                noty({ text: "You have 30 minutes or less left on your session", layout: "topCenter", type: "information", timeout: 20 * 1000 });
                setTimeout(function () { context.pollSessionInfo(context) }, context.normalRefresh);
                return;
            }

            // Session is alive and won't timeout anytime soon.
            console.info("VINSessionHelper: more than 30 minutes left.");
            setTimeout(function () { context.pollSessionInfo(context) }, context.normalRefresh);
            return;
        }

        // If the session was dead but has been reactivated close any timeout notifications and go back to normal polling.
        if (context.sessionAlive == false && sessionInfo.result.uniqueId != context.publicUniqueId)
        {
            context.sessionAlive = true;
            console.info("VINSessionHelper: session reactivated.");
            jQuery.noty.closeAll();
            setTimeout(function () { context.pollSessionInfo(context) }, context.normalRefresh);
            return;
        }

        // The session is still dead. Keep polling.
        console.debug("VINSessionHelper: Still inactive.");
        setTimeout(function () { context.pollSessionInfo(context) }, context.quickRefresh);
        return;
    },
    onError: function (context, status)
    {
        console.error(status);
    },
    Initialize: function ()
    {
        console.log("VINSessionHelper: Initialize");
        this.pollSessionInfo(this);
    }
};

var vinbasejs_check = setInterval(function ()
{
    if (document.readyState === "complete")
    {
        clearInterval(vinbasejs_check);
        //VINSessionHelper.Initialize();
    }
}, 1500);

/* Show Pic */
function PictureHtml(title,img) {
   return '<HTML>' +
        '<HEAD>' +
        '<SCRIPT LANGUAGE="JavaScript1.2" SRC="/JSLib/VIN.js" TYPE="text/javascript"></SCRIPT>' +
        '<TITLE>'+title+'</TITLE>' +
        '<LINK HREF="../ext_iframe/Style/VIN.css" REL="stylesheet" TYPE="text/css">' +
        '<STYLE>' +
        '</STYLE>' +
        '</HE' + 'AD>' + /* he and ad is separate because we have an irule that does a find and replace on '< / h e a d >' and we want this case excluded */
        '<BODY BGCOLOR="White" TOPMARGIN=1 MARGINHEIGHT=1>' +
        '<TABLE WIDTH="100%" BORDER="0" CELLSPACING="0" CELLPADDING="0"><TR>' +
        '<TD WIDTH="74" ALIGN="left"><IMG SRC="../ext_iframe/Images/Navigation/2004Logo.gif" ALT="" WIDTH="74" HEIGHT="30" BORDER="0"></TD>' +
        '<TD WIDTH="162" ALIGN="center"><IMG SRC="../ext_iframe/Images/Navigation/2004Slideshow.gif" ALT="" WIDTH="162" HEIGHT="30" BORDER="0"></TD>' +
        '<TD WIDTH="100%" BACKGROUND="../ext_iframe/Images/Navigation/2004Fill.gif"><IMG SRC="../ext_iframe/Images/Navigation/2004Fill.gif" ALT="" WIDTH="7" HEIGHT="30" BORDER="0"></TD>' +
        '<TD WIDTH="84" ALIGN="right"><A HREF="javascript: parent.window.close();"><IMG SRC="../ext_iframe/Images/Navigation/2004Close.gif" ALT="" WIDTH="84" HEIGHT="30" BORDER="0"></A></TD>' +
        '</TR></TABLE>' +
        '<TABLE ALIGN="CENTER" BORDER="0" CELLPADDING="1" CELLSPACING="0">' +
        '<TR><TD BGCOLOR="#C8C8DC">' +
        '<TABLE BORDER="0" CELLPADDING="2" CELLSPACING="0">' +
        '<TR><TD BGCOLOR="White">' +
        '<CENTER><IMG SRC="'+ img +'" BORDER="0"></CENTER>' +
        '</TD></TR>' +
        '</TABLE>' +
        '</TD></TR>' +
        '</TABLE>' +
        '</BODY>' +
        '</HTML>';
}

function getMemberInfo() {
    $j.ajax({
        url: '/apputil/VINControlRenderer.aspx?ControlName=Member&Template=Image',
        success: function (resp) { memberInfoComplete(resp); },
        async: true
    });
}

function memberInfoComplete(resp) {
    var memberInfo = {
        firstname: '',
        lastname: '',
        email: ''
    };

    if (resp.indexOf("data-firstname") > 0) {
        const parser = new DOMParser();
        const htmlDoc = parser.parseFromString(resp, 'text/html');
        var memberDiv = htmlDoc.getElementsByTagName('div')[0];

        memberInfo.firstname = memberDiv.getAttribute("data-firstname");
        memberInfo.lastname = memberDiv.getAttribute("data-lastname");
        memberInfo.email = memberDiv.getAttribute("data-email");
    }

    window.dispatchEvent(new CustomEvent('memberInfo.complete', { detail: { memberInfo } }));
}

/*  VIN LeftNav  */
$j(document).ready(function () {
    function VINLeftNav_init() {

        var d = new Date();
        var cachebuster = d.getFullYear().toString() + d.getMonth().toString() + d.getDay().toString() + d.getHours().toString();

        var xhr = new XMLHttpRequest();
        xhr.open("GET", "/tools/templates/VINLeftNav.htm?" + cachebuster, true);
        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4 && xhr.status === 200) {
                document.getElementById("VINLeftNav").innerHTML = xhr.responseText;

                let arrow = document.querySelectorAll(".VINLeftNav-arrow");
                for (let i = 0; i < arrow.length; i++) {
                    arrow[i].addEventListener("click", (e) => {
                        let arrowParent = e.target.parentElement.parentElement;
                        arrowParent.classList.toggle("showMenu");
                    });
                }

                let sidebar = document.querySelector(".sidebar");
                let sidebarBtn = document.querySelector(".VINLeftNav-menu");

                if (sidebarBtn) {
                    // Check if sidebarBtn exists
                    sidebarBtn.addEventListener("click", () => {
                        sidebar.classList.toggle("close");
                    });
                } else {
                    console.error("Sidebar button (.VINLeftNav-menu) not found");
                }
            }
        };
        xhr.send();
    }
    if (document.getElementById("VINLeftNav")) {
        VINLeftNav_init();
    }
});