//*************************************************************************
// Alert Notification Manager
// Relies on:
//              /Global/CSS/AlertNotificationManager.css
//              /Global/JS/jquery/jquery.min-vin.js
//              /Global/JS/jquery/plugins/ajaxq.js
//              /Global/JS/jquery/jquery-cookie.js
//              /Global/JS/jquery/plugins/noty/jquery.noty.packaged.js
//              /Global/JS/jquery/plugins/noty/themes/vin.js
//*************************************************************************
var ANM = {
    LoadedInFrame: window !== window.parent,
    AlertsUrl: "/members/cms/ajaxserver/alertnotificationmanager.ashx",
    AlertsPollingInterval: 30000,
    AlertTemplate: "<div class=\"noty_message\"><div class=\"noty_header\"><strong>{0}</strong><span class=\"noty_close_x\" title=\"Dismiss\">X</span></div><div class=\"noty_text\"></div><div class=\"noty_close\"></div></div>",
    SnoozeSelectTemplate: "<select class=\"noty-snooze-select form-control\">{0}</select>",
    Alerts: [],
    MemberAlerts: [],
	TestAlerts: [],
    UniqueID: 0,
    IsIdle: 0,
    CurrentEventType: null,
    EventTypes: {
        Mousemove: "mousemove",
        Click: "click",
        Focus: "focus",
        Scroll: "scroll",
        TouchStart: "touchstart"
    },
    MousePos: {
        x: 0,
        y: 0
    },
    AddXY: "",
    IsInitialized: false,

    Initialize: function() {
        // We don't want this being called from iframes, the parent will have this script running
        if (!ANM.LoadedInFrame) {
            ANM.GetUniqueID();
        } else {
            $j("#spnNotificationBubble").hide();
            $j("#divNotificationContainer").hide();
        }
        return;
    },

    GetUniqueID: function() {
        $j.ajaxq("VIN", {
            global: false,
            timeout: 5000,
            type: "GET",
            data: {},
            url: ANM.AlertsUrl + "/GetUniqueID",
            dataType: "json",
            success: function(result, status, xhr) {
                ANM.UniqueID = result;
                ANM.GetAlerts();
            },
            error: function(xhr, status, error) {
                console.log("GetUniqueID error!");
                console.log(xhr);
            }
        });
    },

    GetAlerts: function() {
        if (ANM.IsIdle === 1) {
            window.setTimeout(function() { ANM.GetAlerts(); }, ANM.AlertsPollingInterval);
            return;
        }
        ANM.IsIdle = 1;
        ANM.AddXY = "";
        if (ANM.CurrentEventType === ANM.EventTypes.Mousemove) {
            ANM.AddXY = "&coords=x" + ANM.MousePos.x + "y" + ANM.MousePos.y;
        }
        $j.ajaxq("VIN", {
            global: false,
            timeout: 5000,
            type: "GET",
            data: {
            },
            url: ANM.AlertsUrl + "/GetAlerts?eventType=" + ANM.CurrentEventType + ANM.AddXY,
            dataType: "json",
            success: function(result, status, xhr) {
                ANM.CurrentEventType = null;
                ANM.GetAlertsCallback(result);
                window.setTimeout(function() { ANM.GetAlerts(); }, ANM.AlertsPollingInterval);
            },
            error: function(xhr, status, error) {
                console.log("GetAlerts error!");
                console.log(xhr);
            }
        });
    },

    DismissGlobalAlert: function (intAlertNotificationID, strAction) {
        $j.ajaxq("VIN", {
            global: false,
            timeout: 5000,
            type: "POST",
            data: {
                intAlertNotificationID: intAlertNotificationID,
                strAction: strAction
            },
            url: ANM.AlertsUrl + "/DismissGlobalAlert",
            dataType: "json",
            success: function (result, status, xhr) {
            },
            error: function (xhr, status, error) {
                console.log("DismissGlobalAlert error!");
                console.log(xhr);
            }
        });
    },

    DismissMemberAlert: function (intAlertNotificationID, strAction) {
        $j.ajaxq("VIN", {
            global: false,
            timeout: 5000,
            type: "POST",
            data: {
                intAlertNotificationID: intAlertNotificationID,
                strAction: strAction
            },
            url: ANM.AlertsUrl + "/DismissMemberAlert",
            dataType: "json",
            success: function (result, status, xhr) {
            },
            error: function (xhr, status, error) {
                console.log("DismissMemberAlert error!");
                console.log(xhr);
            }
        });
    },

    SnoozeGlobalAlert: function (intAlertNotificationID, intSnoozeMinutes) {
        $j.ajaxq("VIN", {
            global: false,
            timeout: 5000,
            type: "POST",
            data: {
                intAlertNotificationID: intAlertNotificationID,
                intSnoozeMinutes: intSnoozeMinutes
            },
            url: ANM.AlertsUrl + "/SnoozeGlobalAlert",
            dataType: "json",
            success: function (result, status, xhr) {
            },
            error: function (xhr, status, error) {
                console.log("SnoozeGlobalAlert error!");
                console.log(xhr);
            }
        });
    },

    SnoozeMemberAlert: function (intAlertNotificationID, intSnoozeMinutes) {
        $j.ajaxq("VIN", {
            global: false,
            timeout: 5000,
            type: "POST",
            data: {
                intAlertNotificationID: intAlertNotificationID,
                intSnoozeMinutes: intSnoozeMinutes
            },
            url: ANM.AlertsUrl + "/SnoozeMemberAlert",
            dataType: "json",
            success: function (result, status, xhr) {
            },
            error: function (xhr, status, error) {
                console.log("SnoozeMemberAlert error!");
                console.log(xhr);
            }
        });
    },

    GetAlertsCallback: function (result) {
        // Set each global alert to not be active
        $j.each(ANM.Alerts, function(index, myAlert) {
            myAlert.IsActive = false;
        });
        // Set each member alert to not be active
        $j.each(ANM.MemberAlerts, function(index, myAlert) {
            myAlert.IsActive = false;
        });
        if (result !== "") {
            var alerts = jQuery.parseJSON(result);
            if (alerts.MemberAlerts !== null && alerts.MemberAlerts.length !== 0) {
                $j.each(alerts.MemberAlerts, function(index, alert) {
					var IsShowSnooze = alert.ShowSnooze;
					if(alert.Title == "Account Recovery Email Missing")
					{
						IsShowSnooze = false;
					}
									
                    var myNewAlert = {
                        ID: alert.AlertNotificationID,
                        Type: alert.Type,
                        Title: alert.Title,
                        Message: alert.Message,
                        ShowDismiss: alert.ShowDismiss,
                        //ShowSnooze: alert.ShowSnooze,
						ShowSnooze: IsShowSnooze,
                        ActionText: alert.ActionText,
                        ActionUrl: alert.ActionUrl,
                        ActionJavaScript: alert.ActionJavaScript,
                        NotificationID: null,
                        Dismissed: false,
                        HideSnoozed: false,
                        Snoozed: alert.SnoozedUntilDate === null ? false : true,
                        IsModal: alert.IsModal,
                        ExpirationDate: alert.ExpirationDate,
                        CurrentSystemTime: alert.CurrentSystemTime,
                        IsActive: true,
                        IsTransientAlert: !alert.IsModal
                    };
                    // If we have an existing alert, make sure we update it, but don't "push" it to the array
                    var blnAlertFound = false;
                    $j.each(ANM.MemberAlerts, function(index, myAlert) {
                        if (myAlert.ID === myNewAlert.ID) {
                            blnAlertFound = true;
                            myAlert.Type = myNewAlert.Type;
                            myAlert.Title = myNewAlert.Title;
                            myAlert.Message = myNewAlert.Message;
                            myAlert.ShowDismiss = myNewAlert.ShowDismiss;
                            myAlert.ShowSnooze = myNewAlert.ShowSnooze;
                            myAlert.ActionText = myNewAlert.ActionText;
                            myAlert.ActionUrl = myNewAlert.ActionUrl;
                            myAlert.ActionJavaScript = myNewAlert.ActionJavaScript;
                            myAlert.Dismissed = myNewAlert.Dismissed;
                            myAlert.HideSnoozed = myAlert.Snoozed === false && myNewAlert.Snoozed;
                            myAlert.Snoozed = myNewAlert.Snoozed;
                            myAlert.ExpirationDate = myNewAlert.ExpirationDate,
                            myAlert.CurrentSystemTime = myNewAlert.CurrentSystemTime,
                            myAlert.IsActive = myNewAlert.IsActive;
                        }
                    });
                    if (!blnAlertFound) {
                        ANM.MemberAlerts.push(myNewAlert);
                    }
                });
            }
            if (alerts.GlobalAlerts !== null && alerts.GlobalAlerts.length !== 0) {
                $j.each(alerts.GlobalAlerts, function(index, alert) {
                    if (!ANM.IsAlertForDomain(alert.Domain)) {
                        return true;
                    }
                    var myNewAlert = {
                        ID: alert.AlertNotificationID,
                        Domain: alert.Domain,
                        Name: alert.AlertName,
                        Message: "<p />" + alert.AlertMessage + "<p />",
                        ShowDismiss: alert.ShowDismiss,
                        ShowSnooze: alert.ShowSnooze,
                        NotificationID: null,
                        Dismissed: false,
                        HideSnoozed: false,
                        Snoozed: alert.SnoozedUntilDate === null ? false : true,
                        ExpirationDate: alert.EndDate,
                        CurrentSystemTime: alert.CurrentSystemTime,
                        IsActive: true
                    };
                    // If we have an existing alert, make sure we update it, but don't "push" it to the array
                    var blnAlertFound = false;
                    $j.each(ANM.Alerts, function(index, myAlert) {
                        if (myNewAlert.ID === myAlert.ID) {
                            blnAlertFound = true;
                            myAlert.Domain = myNewAlert.Domain;
                            myAlert.Name = myNewAlert.Name;
                            myAlert.Message = myNewAlert.Message;
                            myAlert.ShowDismiss = myNewAlert.ShowDismiss;
                            myAlert.ShowSnooze = myNewAlert.ShowSnooze;
                            myAlert.Dismissed = myNewAlert.Dismissed;
                            myAlert.HideSnoozed = myAlert.Snoozed === false && myNewAlert.Snoozed;
                            myAlert.Snoozed = myNewAlert.Snoozed;
                            myAlert.ExpirationDate = myNewAlert.ExpirationDate,
                            myAlert.CurrentSystemTime = myNewAlert.CurrentSystemTime,
                            myAlert.IsActive = myNewAlert.IsActive;
                        }
                    });
                    if (!blnAlertFound) {
                        ANM.Alerts.push(myNewAlert);
                    }
                });
            }
        }
        // Update the member alerts based on actions from this and any other open windows
        $j.each(ANM.MemberAlerts, function (index, myAlert) {
            if (myAlert.IsActive === false || myAlert.HideSnoozed) {
                $j.noty.close(myAlert.NotificationID);
                myAlert.NotificationID = null;
            }
        });
        // Update the global alerts based on actions from this and any other open windows
        $j.each(ANM.Alerts, function(index, myAlert) {
            if (myAlert.IsActive === false || myAlert.HideSnoozed) {
                $j.noty.close(myAlert.NotificationID);
                myAlert.NotificationID = null;
            }
        });
        // Remove inactive member alerts
        ANM.MemberAlerts = $j.grep(ANM.MemberAlerts, function(myAlert) {
            if (myAlert.IsActive === false) {
                return false;
            } else {
                return true;
            }
        });
        // Remove inactive global alerts
        ANM.Alerts = $j.grep(ANM.Alerts, function(myAlert) {
            if (myAlert.IsActive === false) {
                return false;
            } else {
                return true;
            }
        });
        // Show the member alerts (IsModal === true)
        ANM.ShowMemberAlerts(false);
        // Show the global alerts
        ANM.ShowAlerts(false);
        // Show the transient member alerts (IsModal === false)
        ANM.ShowTransientMemberAlerts();
        // Done because we need to account for the scenario where the alerts have been dealt with on other windows
        ANM.UpdateNotificationBubble();
        ANM.CloseNotificationContainerCheck();
        ANM.IsInitialized = true;
    },

    SetCookieValue: function(strCookieName, strValue, intExpirationDays) {
        $j.cookie(ANM.UniqueID + strCookieName, strValue, { expires: intExpirationDays, path: "/" });
    },

    GetCookieValue: function(strCookieName) {
        var strValue = $j.cookie(ANM.UniqueID + strCookieName);
        if (typeof strValue === "undefined") {
            strValue = "";
        }
        return strValue;
    },

    IsAlertForDomain: function(strDomain) {
        if (strDomain === "") {
            return true;
        }
        if (location.href.toLowerCase().indexOf("localhost") > -1) {
            strDomain = strDomain.replace("vin.com", "localhost.vin.com");
        }
        if (location.href.toLowerCase().indexOf(strDomain.toLowerCase()) > -1) {
            return true;
        } else {
            return false;
        }
    },

    CloseAlert: function(notyObject, strAction) {
        var intSnoozeLength = 1440;
        try {
            intSnoozeLength = $j(notyObject.$buttons.find(".noty-snooze-select")).val();
        } catch (e) {
            console.log(e)
        }
        $j.each(ANM.Alerts, function(index, myAlert) {
            if (myAlert.NotificationID === notyObject.options.id) {
                myAlert.NotificationID = null;
                myAlert.Dismissed = (strAction === "Dismissed" || strAction === "Acknowledged") ? true : myAlert.Dismissed;
                myAlert.Snoozed = strAction === "Snoozed" ? true : myAlert.Snoozed;
                if (strAction === "Dismissed" || strAction === "Acknowledged") {
                    ANM.DismissGlobalAlert(myAlert.ID, strAction);
                } else {
                    ANM.SnoozeGlobalAlert(myAlert.ID, intSnoozeLength);
                }
            }
        });
        $j.each(ANM.MemberAlerts, function(index, myAlert) {
            if (myAlert.NotificationID === notyObject.options.id) {
                myAlert.NotificationID = null;
                myAlert.Dismissed = (strAction === "Dismissed" || strAction === "Acknowledged") ? true : myAlert.Dismissed;
                myAlert.Snoozed = strAction === "Snoozed" ? true : myAlert.Snoozed;
                if (strAction === "Dismissed" || strAction === "Acknowledged") {
                    ANM.DismissMemberAlert(myAlert.ID, strAction);
                } else {
                    ANM.SnoozeMemberAlert(myAlert.ID, intSnoozeLength);
                }
            }
        });
        ANM.TestAlerts = $j.grep(ANM.TestAlerts, function(myAlert,index) {
            if (myAlert.NotificationID === notyObject.options.id) {
                myAlert.NotificationID = null;
                myAlert.Dismissed = (strAction === "Dismissed" || strAction === "Acknowledged") ? true : myAlert.Dismissed;
                myAlert.Snoozed = strAction === "Snoozed" ? true : myAlert.Snoozed;
                if (strAction === "Dismissed" || strAction === "Acknowledged") {
                    ANM.TestAlerts = [];
					return false;					
                } else {
                    ANM.TestAlerts = [];
					return true;					
                }				
            }
			return true;
        });		
        ANM.UpdateNotificationBubble();
        ANM.CloseNotificationContainerCheck();
        $j.noty.close(notyObject.options.id);
    },

    AlertDismissed: function (notyObject) {
        ANM.CloseAlert(notyObject, "Dismissed");
    },

    AlertAcknowledged: function(notyObject) {
        ANM.CloseAlert(notyObject, "Acknowledged");
    },

    AlertSnoozed: function (notyObject) {
        ANM.CloseAlert(notyObject, "Snoozed");
    },

    AlertGo: function(notyObject) {
        $j.each(ANM.MemberAlerts, function(index, myAlert) {
            if (myAlert.NotificationID === notyObject.options.id && myAlert.ActionUrl !== null && myAlert.ActionUrl !== "") {
                window.open(myAlert.ActionUrl, "_blank");
            } else if (myAlert.NotificationID === notyObject.options.id && myAlert.ActionJavaScript !== null && myAlert.ActionJavaScript !== "") {
                window.eval(myAlert.ActionJavaScript);
            }
        });
        ANM.CloseAlert(notyObject, "Dismissed");
    },

    RemoveNotificationBubbleAnimation: function() {
        window.setTimeout(function() { $j("#spnNotificationBubble").removeClass("notification-bubble-animating"); }, 1000); // remove CSS animating class
    },

    CloseNotificationContainerCheck: function() {
        var intNumberOfAlerts = 0;
        $j.each(ANM.Alerts, function (index, myAlert) {
            if (myAlert.NotificationID !== null) {
                intNumberOfAlerts++;
            }
        });
        $j.each(ANM.MemberAlerts, function(index, myAlert) {
            if (myAlert.NotificationID !== null) {
                intNumberOfAlerts++;
            }
        });
	    $j.each(ANM.TestAlerts, function(index, myAlert) {
            if (myAlert.NotificationID !== null) {
                intNumberOfAlerts++;
            }
        });
        if (intNumberOfAlerts === 0) {
            $j("#divNotificationContainer").hide();
        }
    },

    UpdateNotificationBubble: function() {
        var intNumberOfAlerts = 0;
        var intCurrentNumberOfAlerts = parseInt($j("#spnNotificationBubble").html());
        $j.each(ANM.Alerts, function(index, myAlert) {
            if (myAlert.Dismissed === false) {
                intNumberOfAlerts++;
            }
        });
        $j.each(ANM.MemberAlerts, function(index, myAlert) {
            if (myAlert.Dismissed === false) {
                intNumberOfAlerts++;
            }
        });
        $j.each(ANM.TestAlerts, function(index, myAlert) {
            if (myAlert.Dismissed === false) {
                intNumberOfAlerts++;
            }
        });		
        $j("#spnNotificationBubble").html(intNumberOfAlerts);
        if (intNumberOfAlerts === 0) {
            $j("#spnNotificationBubble").hide();
        } else {
            $j("#spnNotificationBubble").show();
            if (intCurrentNumberOfAlerts !== intNumberOfAlerts) {
                $j("#spnNotificationBubble").addClass("notification-bubble-animating"); // animate it
                ANM.RemoveNotificationBubbleAnimation();
            }
        }
    },

    DateAdd: function (date, interval, units) {
        if (!(date instanceof Date)) { return undefined; }
        var ret = new Date(date); // don't change original date
        var checkRollover = function () { if (ret.getDate() !== date.getDate()) { ret.setDate(0); } };
        switch (String(interval).toLowerCase()) {
            case "year": ret.setFullYear(ret.getFullYear() + units); checkRollover(); break;
            case "quarter": ret.setMonth(ret.getMonth() + 3 * units); checkRollover(); break;
            case "month": ret.setMonth(ret.getMonth() + units); checkRollover(); break;
            case "week": ret.setDate(ret.getDate() + 7 * units); break;
            case "day": ret.setDate(ret.getDate() + units); break;
            case "hour": ret.setTime(ret.getTime() + units * 3600000); break;
            case "minute": ret.setTime(ret.getTime() + units * 60000); break;
            case "second": ret.setTime(ret.getTime() + units * 1000); break;
            default: ret = undefined; break;
        }
        return ret;
    },

    GetSnoozeSelect: function (notyObject) {
        var alert = null;
        $j.each(ANM.Alerts, function (index, myAlert) {
            if (myAlert.NotificationID === notyObject.options.id) {
                alert = myAlert;
                return false;
            }
        });
        $j.each(ANM.MemberAlerts, function (index, myAlert) {
            if (myAlert.NotificationID === notyObject.options.id) {
                alert = myAlert;
                return false;
            }
        });
        $j.each(ANM.TestAlerts, function (index, myAlert) {
            if (myAlert.NotificationID === notyObject.options.id) {
                alert = myAlert;
                return false;
            }
        });		
        var strOptions = "<option value=\"15\">15 Minutes</option><option value=\"240\">4 Hours</option><option value=\"1440\" selected>1 Day</option>";
        if (alert !== null && alert.ExpirationDate !== null) {
            strOptions = "";
            var dte15MinutesFromNow = ANM.DateAdd(new Date(parseInt(alert.CurrentSystemTime.substr(6))), "minute", 15);
            var dte240MinutesFromNow = ANM.DateAdd(new Date(parseInt(alert.CurrentSystemTime.substr(6))), "minute", 240);
            var dte1440MinutesFromNow = ANM.DateAdd(new Date(parseInt(alert.CurrentSystemTime.substr(6))), "minute", 1440);
            var dteExpirationDate = new Date(parseInt(alert.ExpirationDate.substr(6)));
            var bln240Minutes = dte240MinutesFromNow.getTime() <= dteExpirationDate.getTime();
            var bln1440Minutes = dte1440MinutesFromNow.getTime() <= dteExpirationDate.getTime();
            if (dte15MinutesFromNow.getTime() <= dteExpirationDate.getTime()) {
                if (bln240Minutes) {
                    strOptions += "<option value=\"15\">15 Minutes</option>";
                } else {
                    strOptions += "<option value=\"15\" selected>15 Minutes</option>";
                }
            }
            if (dte240MinutesFromNow.getTime() <= dteExpirationDate.getTime()) {
                if (bln1440Minutes) {
                    strOptions += "<option value=\"240\">4 Hours</option>";
                }
                else {
                    strOptions += "<option value=\"240\" selected>4 Hours</option>";
                }
            }
            if (dte1440MinutesFromNow.getTime() <= dteExpirationDate.getTime()) {
                strOptions += "<option value=\"1440\" selected>1 Day</option>";
            }
        }
        if (strOptions === "") {
            return "";
        }
        return ANM.SnoozeSelectTemplate.replace("{0}", strOptions);
    },

    ShowNotifications: function () {
        ANM.ShowAlerts(true);
        ANM.ShowMemberAlerts(true);
    },

    ShowMemberAlerts: function (blnShowNotificationContainer) {
        $j.each(ANM.MemberAlerts, function(index, myAlert) {
            if (myAlert.NotificationID !== null) {
                $j.noty.setText(myAlert.NotificationID, myAlert.Message);
            } else if (blnShowNotificationContainer || (myAlert.IsModal && !myAlert.Snoozed && !myAlert.IsTransientAlert)) {
                blnShowNotificationContainer = true;
                var n = $j("#divNotifications").noty({
                    layout: "topCenter",
                    theme: "relax",
                    type: "alert",
                    text: myAlert.Message,
                    template: ANM.AlertTemplate.replace("{0}", myAlert.Title),
                    modal: true,
                    force: true,
                    maxVisible: 99,
                    closeWith: [],
                    buttons: [
                        {
                            addClass: "noty_button noty_go",
                            text: myAlert.ActionText,
                            onClick: function(notyObject) {
                                ANM.AlertGo(notyObject);
                            }
                        },
                        {
                            addClass: myAlert.ShowDismiss ? "noty_button noty_dismiss" : "noty_button noty_dismiss noty_button_remove",
                            text: "Dismiss",
                            onClick: function(notyObject) {
                                ANM.AlertDismissed(notyObject);
                            }
                        },
                        {
                            addClass: myAlert.ShowSnooze ? "noty_button noty_snooze" : "noty_button noty_snooze noty_button_remove",
                            text: "Snooze",
                            onClick: function(notyObject) {
                                ANM.AlertSnoozed(notyObject);
                            }
                        }
                    ],
                    callback: {
                        afterShow: function() {
                            var notyObject = this;
                            var strSnoozeSelect = ANM.GetSnoozeSelect(notyObject);
                            $j(notyObject.$message.find("a")).each(function () {
                                $j(this).click(function () {
                                    ANM.AlertAcknowledged(notyObject);
                                });
                            });
                            if ($j(notyObject.$buttons.find(".noty_dismiss")).hasClass("noty_button_remove")) {
                                $j(notyObject.$buttons.find(".noty_dismiss")).remove();
                            }
                            if ($j(notyObject.$buttons.find(".noty_snooze")).hasClass("noty_button_remove") || strSnoozeSelect === "") {
                                $j(notyObject.$buttons.find(".noty_snooze")).remove();
                            }
                            if ($j(notyObject.$buttons).children().length === 0) {
                                $j(notyObject.$buttons).remove();
                            }
                            $j(notyObject.$buttons).css("background-color", "");
                            $j(notyObject.$buttons.find(".noty_go")).prop("title", "Go");
                            $j(notyObject.$buttons.find(".noty_dismiss")).prop("title", "Dismisses the alert and you won't see it again.");
                            $j(notyObject.$buttons.find(".noty_snooze")).prop("title", "Snoozes the alert, and you will be able to respond to it later.");
                            if (myAlert.ShowDismiss) {
                                var notyCloseX = $j(notyObject.$bar).find(".noty_close_x");
                                $j(notyCloseX).click(function () {
                                    ANM.AlertDismissed(notyObject);
                                });
                            } else {
                                $j(notyObject.$bar).find(".noty_close_x").remove();
                            }
                            if (myAlert.ActionText === null || myAlert.ActionText === "") {
                                $j(notyObject.$buttons.find(".noty_go")).hide();
                            }
                            if ($j(notyObject.$buttons.find(".noty_snooze")).length !== 0) {
                                $j(notyObject.$buttons.find(".noty_snooze")).before(strSnoozeSelect);
                            }
                        }
                    }
                });
                myAlert.NotificationID = n.options.id;
            }
        });
        if (blnShowNotificationContainer) {
            ANM.ShowNotificationContainer();
        }
        ANM.UpdateNotificationBubble();
    },

    ShowTransientMemberAlerts: function () {
        $j.each(ANM.MemberAlerts, function (index, myAlert) {
            if (!myAlert.IsModal) {
                myAlert.IsModal = true;
                if (myAlert.Snoozed) {
                    return;
                }
                var n = noty({
                    layout: "topRight",
                    theme: "relax",
                    type: "alert",
                    timeout: 5000,
                    text: myAlert.Message,
                    template: ANM.AlertTemplate.replace("{0}", myAlert.Title),
                    force: true,
                    maxVisible: 99,
                    closeWith: [],
                    buttons: [
                        {
                            addClass: "noty_button noty_go",
                            text: myAlert.ActionText,
                            onClick: function (notyObject) {
                                ANM.AlertGo(notyObject);
                            }
                        },
                        {
                            addClass: myAlert.ShowDismiss ? "noty_button noty_dismiss" : "noty_button noty_dismiss noty_button_remove",
                            text: "Dismiss",
                            onClick: function (notyObject) {
                                ANM.AlertDismissed(notyObject);
                            }
                        },
                        {
                            addClass: myAlert.ShowSnooze ? "noty_button noty_snooze" : "noty_button noty_snooze noty_button_remove",
                            text: "Snooze",
                            onClick: function (notyObject) {
                                ANM.AlertSnoozed(notyObject);
                            }
                        }
                    ],
                    callback: {
                        onClose: function () {
                            var notyObject = this;
                            // Clear the NotificationID so that it can be shown as a modal
                            $j.each(ANM.MemberAlerts, function (index, myAlert) {
                                if (myAlert.NotificationID === notyObject.options.id) {
                                    myAlert.NotificationID = null;
                                }
                            });
                        },
                        afterShow: function () {
                            var notyObject = this;
                            var strSnoozeSelect = ANM.GetSnoozeSelect(notyObject);
                            $j(notyObject.$message.find("a")).each(function () {
                                $j(this).click(function () {
                                    ANM.AlertAcknowledged(notyObject);
                                });
                            });
                            if ($j(notyObject.$buttons.find(".noty_dismiss")).hasClass("noty_button_remove")) {
                                $j(notyObject.$buttons.find(".noty_dismiss")).remove();
                            }
                            if ($j(notyObject.$buttons.find(".noty_snooze")).hasClass("noty_button_remove") || strSnoozeSelect === "") {
                                $j(notyObject.$buttons.find(".noty_snooze")).remove();
                            }
                            if ($j(notyObject.$buttons).children().length === 0) {
                                $j(notyObject.$buttons).remove();
                            }
                            $j(notyObject.$buttons).css("background-color", "");
                            $j(notyObject.$buttons.find(".noty_go")).prop("title", "Go");
                            $j(notyObject.$buttons.find(".noty_dismiss")).prop("title", "Dismisses the alert and you won't see it again.");
                            $j(notyObject.$buttons.find(".noty_snooze")).prop("title", "Snoozes the alert, and you will be able to respond to it later.");
                            if (myAlert.ShowDismiss) {
                                var notyCloseX = $j(notyObject.$bar).find(".noty_close_x");
                                $j(notyCloseX).click(function () {
                                    ANM.AlertDismissed(notyObject);
                                });
                            } else {
                                $j(notyObject.$bar).find(".noty_close_x").remove();
                            }
                            if (myAlert.ActionText === "") {
                                $j(notyObject.$buttons.find(".noty_go")).hide();
                            }
                            if ($j(notyObject.$buttons.find(".noty_snooze")).length !== 0) {
                                $j(notyObject.$buttons.find(".noty_snooze")).before(strSnoozeSelect);
                            }
                        }
                    }
                });
                myAlert.NotificationID = n.options.id;
            }
        });
    },

    ShowAlerts: function (blnShowNotificationContainer) {
        $j.each(ANM.Alerts, function (index, myAlert) {
            if (myAlert.NotificationID !== null) {
                $j.noty.setText(myAlert.NotificationID, myAlert.Message);
            } else if (blnShowNotificationContainer || !myAlert.Snoozed) {
                blnShowNotificationContainer = true;
                var n = $j("#divNotifications").noty({
                    layout: "topCenter",
                    theme: "relax",
                    type: "alert",
                    text: myAlert.Message,
                    template: ANM.AlertTemplate.replace("{0}", myAlert.Name),
                    modal: true,
                    force: true,
                    maxVisible: 99,
                    closeWith: [],
                    buttons: [
                        {
                            addClass: myAlert.ShowDismiss ? "noty_button noty_dismiss" : "noty_button noty_dismiss noty_button_remove",
                            text: "Dismiss",
                            onClick: function(notyObject) {
                                ANM.AlertDismissed(notyObject);
                            }
                        },
                        {
                            addClass: myAlert.ShowSnooze ? "noty_button noty_snooze" : "noty_button noty_snooze noty_button_remove",
                            text: "Snooze",
                            onClick: function(notyObject) {
                                ANM.AlertSnoozed(notyObject);
                            }
                        }
                    ],
                    callback: {
                        afterShow: function() {
                            var notyObject = this;
                            var strSnoozeSelect = ANM.GetSnoozeSelect(notyObject);
                            $j(notyObject.$message.find("a")).each(function () {
                                $j(this).click(function () {
                                    ANM.AlertAcknowledged(notyObject);
                                });
                            });
                            if ($j(notyObject.$buttons.find(".noty_dismiss")).hasClass("noty_button_remove")) {
                                $j(notyObject.$buttons.find(".noty_dismiss")).remove();
                            }
                            if ($j(notyObject.$buttons.find(".noty_snooze")).hasClass("noty_button_remove") || strSnoozeSelect === "") {
                                $j(notyObject.$buttons.find(".noty_snooze")).remove();
                            }
                            if ($j(notyObject.$buttons).children().length === 0) {
                                $j(notyObject.$buttons).remove();
                            }
                            $j(notyObject.$buttons).css("background-color", "");
                            $j(notyObject.$buttons.find(".noty_dismiss")).prop("title", "Dismisses the alert and you won't see it again.");
                            $j(notyObject.$buttons.find(".noty_snooze")).prop("title", "Snoozes the alert, and you will be able to respond to it later.");
                            if (myAlert.ShowDismiss) {
                                var notyCloseX = $j(notyObject.$bar).find(".noty_close_x");
                                $j(notyCloseX).click(function () {
                                    ANM.AlertDismissed(notyObject);
                                });
                            } else {
                                $j(notyObject.$bar).find(".noty_close_x").remove();
                            }
                            if ($j(notyObject.$buttons.find(".noty_snooze")).length !== 0) {
                                $j(notyObject.$buttons.find(".noty_snooze")).before(strSnoozeSelect);
                            }
                        }
                    }
                });
                myAlert.NotificationID = n.options.id;
            }
        });
        if (blnShowNotificationContainer) {
            ANM.ShowNotificationContainer();
        }
        ANM.UpdateNotificationBubble();
    },

    ShowNotificationContainer: function () {
        $j("#divNotificationContainer").show();
        $j("html, body").scrollTop(0);
        ANM.CenterNotificationContainer();
    },

    CenterNotificationContainer: function() {
        $j("#divNotificationContainer").css({
            "position": "absolute",
            "left": "50%",
            "margin-left": -$j("#divNotificationContainer").outerWidth() / 2
        });
    },
	
	TestUserNotification: function(title, message, showDismiss, showSnooze){
		var alert = {
			ID: Math.floor(Math.random() * 100000),
			Type: 'Test',
			Title: title,
			Message: message,
			ShowDismiss: showDismiss,
			ShowSnooze: showSnooze,
			ActionText: null,
			ActionUrl: null,
			ActionJavaScript: null,
			NotificationID: null,
			Dismissed: false,
			HideSnoozed: false,
			Snoozed: false,
			IsModal: true,
			ExpirationDate: null,
			CurrentSystemTime: null,
			IsActive: true,
			IsTransientAlert: !true
        };
        ANM.TestAlerts = []; //only one shown during preview
		ANM.TestAlerts.push(alert);
		ANM.DisplayTestAlert(true)
	},
	
	DisplayTestAlert: function(blnShowNotificationContainer){
        $j.each(ANM.TestAlerts, function(index, alert) {
            if (alert.NotificationID !== null) {
                $j.noty.setText(alert.NotificationID, alert.Message);
            } else if (blnShowNotificationContainer || (alert.IsModal && !alert.Snoozed && !alert.IsTransientAlert)) {
                var n = $j("#divNotifications").noty({
                    layout: "topCenter",
                    theme: "relax",
                    type: "alert",
                    text: alert.Message,
                    template: ANM.AlertTemplate.replace("{0}", alert.Title),
                    modal: true,
                    force: true,
                    maxVisible: 99,
					//timeout: 5000,
                    closeWith: [],
                    buttons: [
                        {
                            addClass: "noty_button noty_go",
                            text: alert.ActionText,
                            onClick: function(notyObject) {
                                ANM.AlertGo(notyObject);
                            }
                        },
                        {
                            addClass: alert.ShowDismiss ? "noty_button noty_dismiss" : "noty_button noty_dismiss noty_button_remove",
                            text: "Dismiss",
                            onClick: function(notyObject) {
                                ANM.AlertDismissed(notyObject);
                            }
                        },
                        {
                            addClass: alert.ShowSnooze ? "noty_button noty_snooze" : "noty_button noty_snooze noty_button_remove",
                            text: "Snooze",
                            onClick: function(notyObject) {
                                ANM.AlertSnoozed(notyObject);
                            }
                        }
                    ],
                    callback: {
                        afterShow: function() {
                            var notyObject = this;
                            var strSnoozeSelect = ANM.GetSnoozeSelect(notyObject);
                            $j(notyObject.$message.find("a")).each(function () {
                                $j(this).click(function () {
                                    ANM.AlertAcknowledged(notyObject);
                                });
                            });
                            if ($j(notyObject.$buttons.find(".noty_dismiss")).hasClass("noty_button_remove")) {
                                $j(notyObject.$buttons.find(".noty_dismiss")).remove();
                            }
                            if ($j(notyObject.$buttons.find(".noty_snooze")).hasClass("noty_button_remove") || strSnoozeSelect === "") {
                                $j(notyObject.$buttons.find(".noty_snooze")).remove();
                            }
                            if ($j(notyObject.$buttons).children().length === 0) {
                                $j(notyObject.$buttons).remove();
                            }
                            $j(notyObject.$buttons).css("background-color", "");
                            $j(notyObject.$buttons.find(".noty_go")).prop("title", "Go");
                            $j(notyObject.$buttons.find(".noty_dismiss")).prop("title", "Dismisses the alert and you won't see it again.");
                            $j(notyObject.$buttons.find(".noty_snooze")).prop("title", "Snoozes the alert, and you will be able to respond to it later.");
                            if (alert.ShowDismiss) {
                                var notyCloseX = $j(notyObject.$bar).find(".noty_close_x");
                                $j(notyCloseX).click(function () {
                                    ANM.AlertDismissed(notyObject);
                                });
                            } else {
                                $j(notyObject.$bar).find(".noty_close_x").remove();
                            }
                            if (alert.ActionText === null || alert.ActionText === "") {
                                $j(notyObject.$buttons.find(".noty_go")).hide();
                            }
                            if ($j(notyObject.$buttons.find(".noty_snooze")).length !== 0) {
                                $j(notyObject.$buttons.find(".noty_snooze")).before(strSnoozeSelect);
                            }
                        }
                    }
                });
				
			 alert.NotificationID = n.options.id;			 
		    }
		});  
		if (blnShowNotificationContainer) {
            ANM.ShowNotificationContainer();
        }
        ANM.UpdateNotificationBubble();
	},
	
    GetTestContent: function (title, message, showDismiss, showSnooze, uniqueId) {
        $j.ajaxq("VIN", {
            global: false,
            timeout: 5000,
            type: "POST",
            data: {
				uniqueID: uniqueId,
                msg: message,
                documentID: $j("[id*='txtDocumentID']").val()
            },
            url: ANM.AlertsUrl + "/GetTestContent",
            dataType: "json",
            success: function (result, status, xhr) {
				 ANM.TestUserNotification(title, result, showDismiss, showSnooze);
            },
            error: function (xhr, status, error) {
                console.log("DismissMemberAlert error!");
                console.log(xhr);
            }
        });
    }	
};

$j(document).ready(function() {
    if (typeof IgnoreAlertNotification !== "undefined" && IgnoreAlertNotification == "1") {
        return;
    }
    var strNotificationBubble = "<span id=\"spnNotificationBubble\" class=\"notification-bubble\" onclick=\"javascript: ANM.ShowNotifications(); return false;\" title=\"Click to show snoozed alerts\" style=\"display: none;\">0</span>";
    var strNotificationContainer =
        "<div id=\"divNotificationContainer\" class=\"notification-container\">" +
            "   <div>" +
            "       <div style=\"float: right;\">" +
            "           <a style=\"cursor: pointer; padding-right: 10px;\" href=\"http://www.vin.com/doc/?id=6937755\" target=\"_blank\" \"><img title=\"Help\" src=\"/Global/Images/Icon/help_icon2.gif\" /></a>" +
            "       </div>" +
            "   </div>" +
            "   <div id=\"divNotifications\" style=\"clear: both; padding: 5px 0px;\">" +
            "   </div>" +
            "</div>";
    $j(strNotificationContainer).appendTo("body");
    if (typeof NotificationBubbleBeforeElementID !== "undefined" && $j("#" + NotificationBubbleBeforeElementID).length) {
        $j(strNotificationBubble).insertBefore("#" + NotificationBubbleBeforeElementID);
    } else if (typeof NotificationBubbleAfterElementID !== "undefined" && $j("#" + NotificationBubbleAfterElementID).length) {
        $j(strNotificationBubble).insertAfter("#" + NotificationBubbleAfterElementID);
    } else if ($j("#Menu_Logout").length) {
        $j("[id^='Menu_Logout']").attr("id", function() {
                if ($j(this).is(":visible")) {
                    $j(strNotificationBubble).insertBefore(this);
                }
            });
    } else if ($j("#liWelcome").length) {
        $j("[id^='liWelcome']").attr("id", function() {
                if ($j(this).is(":visible")) {
                    $j(strNotificationBubble).insertAfter(this);
                }
            });
    } else if ($j("#lblMemberName").length) {
        $j("[id^='lblMemberName']").attr("id", function() {
                if ($j(this).is(":visible")) {
                    $j(strNotificationBubble).insertAfter(this);
                }
            });
    } else {
        $j(strNotificationBubble).appendTo("body");
        $j("#spnNotificationBubble").removeClass("notification-bubble").addClass("notification-bubble-center");
    }
    // Reset the idle flag when appropriate
    $j(window).mousemove(function (e) {
        // set the mouse position
        ANM.MousePos.x = e.pageX;
        ANM.MousePos.y = e.pageY;
        ANM.IsIdle = 0;
        ANM.CurrentEventType = ANM.EventTypes.Mousemove;
    });
    $j(window).click(function () {
        ANM.IsIdle = 0;
        ANM.CurrentEventType = ANM.EventTypes.Click;
    });
    $j(window).focus(function () {
        ANM.IsIdle = 0;
        ANM.CurrentEventType = ANM.EventTypes.Focus;
    });
    $j(window).scroll(function () {
        ANM.IsIdle = 0;
        ANM.CurrentEventType = ANM.EventTypes.Scroll;
    });
    $j(window).on("touchstart", function () {
        ANM.IsIdle = 0;
        ANM.CurrentEventType = ANM.EventTypes.TouchStart;
    });
    $j("iframe").each(function () {
        $j(this).bind("load", function () {
            // There are some oddities between browsers, but this is better than nothing
            var iframe = $j(this).contents().get(0);
            $j(iframe).mousemove(function () {
                ANM.IsIdle = 0;
                ANM.CurrentEventType = ANM.EventTypes.Mousemove;
            });
            $j(iframe).click(function () {
                ANM.IsIdle = 0;
                ANM.CurrentEventType = ANM.EventTypes.Click;
            });
            $j(iframe).focus(function () {
                ANM.IsIdle = 0;
                ANM.CurrentEventType = ANM.EventTypes.Focus;
            });
            $j(iframe).scroll(function () {
                ANM.IsIdle = 0;
                ANM.CurrentEventType = ANM.EventTypes.Scroll;
            });
            $j(iframe).contents().find("body").scroll(function () {
                ANM.IsIdle = 0;
                ANM.CurrentEventType = ANM.EventTypes.Scroll;
            });
            $j(iframe).on("touchstart", function () {
                ANM.IsIdle = 0;
                ANM.CurrentEventType = ANM.EventTypes.TouchStart;
            });
        });
    });
    // Center the notification dashboard on a resize
    $j(window).resize(ANM.CenterNotificationContainer);
    // Initialize the ANM library
    if (IsImpersonation()) {
        console.log("Alert Notification disabled; Impersonate is active.");
    } else {
        ANM.Initialize();
    }
});

//*************************************************************************
// VIN Chat Alerts
//*************************************************************************
//*************************************************************************
// AUDIO NOTIFICATION
//*************************************************************************
$j(document).ready(function() {
    "use strict";
    var w = window;
    var _audioNotification = {
        soundPath: w.location.origin + "/Global/Audio/messagealert.mp3",
        audio: null,
        playSound: playSound,
        isActive: true
    };
    w._audioNotification = _audioNotification;
    function playSound() {
        _audioNotification.audio.play();
    }
    function init() {
        _audioNotification.audio = new Audio(_audioNotification.soundPath);
    }
    init();
});

//*************************************************************************
// NOTIFICATION API
//*************************************************************************
$j(document).ready(function() {
    "use strict";
    var w = window;
    // set up main notification object 
    var _notification = {
            // objects
            supported: false,
            permitted: false,
            permission: {
                granted: "granted",
                denied: "denied",
                default: "default"
            },
            options: {
                body: "Default",
                icon: w.location.origin + "../../../members/images/api_textbubble_outline.png" // need the image/icon
            },
            // functions
            displayNotification: function(title) {
                var _new = new Notification(title, this.options);
                _new.addEventListener("click", function(e) {
                    this.close();
                });
                setTimeout(_new.close.bind(_new), 8000);
            },
            getPermissionPromise: function(t) {
                var d = $j.Deferred();
                if (t.supported) {
                    Notification.requestPermission().then(function(result) {
                        if (result == t.permission.granted) {
                            t.permitted = true;
                        }
                        d.resolve();
                    });
                }
                return d.promise();
            },
            init: function() { this.setSupport(); },
            isSupportNotification: function() { return ("Notification" in window); },
            setIcon: function(i) { this.options.icon = i; },
            setBody: function(b) { this.options.body = b; },
            setSupport: function() { this.supported = this.isSupportNotification(); }
        },
        // set up utility object
        _util = {
            focus: false,
            getFocus: function() {
                return this.focus;
            },
            getRandomNumber: function(r) {
                return Math.floor(Math.random() * r);
            },
            setUpFocusEvent: function() {
                $j(w).on("focus blur", function(e) {
                    switch (e.type) {
                        case "blur":
                            _util.focus = false;
                            break;
                        case "focus":
                            _util.focus = true;
                            break;
                    }
                });
            }
        },
        _vinnotification = {
            setUpNotification: function(t, b) {
                var n = _notification;
                if (n.supported) {
                    n.getPermissionPromise(n).done(function() {
                        n.setBody(b);
                        n.displayNotification(t);
                    });
                }
            }
        }
    // initialize
    if (IsImpersonation()) {
        console.log("Notification API is disabled; Impersonation is active.");
    } else {
        _notification.init();
        w._vinnotification = _vinnotification;
    }
});

//*************************************************************************
// BEGIN VIN CHAT ALERT CODE
//*************************************************************************
// Global Variables
var n = {};
var alertNotys = [];

// Noty custom layout 
$j.noty.layouts.customBottomLeft = {
    name: "customBottomLeft",
    options: {},
    container: {
        object: "<ul id=\"noty_customBottomLeft_layout_container\" />",
        selector: "ul#noty_customBottomLeft_layout_container",
        style: function() {
            $j(this).css({
                bottom: 20,
                left: 20,
                position: "fixed",
                width: "310px",
                height: "auto",
                margin: 0,
                padding: 0,
                listStyleType: "none",
                zIndex: 10000000
            });
        }
    },
    parent: {
        object: "<li />",
        selector: "li",
        css: {}
    },
    css: {
        display: "none",
        marginBottom: "5px",
        padding: "4px"
    },
    addClass: ""
};

// new message function 
function newMessage(msg, type, otherdata, dismiss_func, toid, fromid) {
    if (otherdata == "msgalert") {
        n = noty({
            text: msg,
            type: type,
            dismissQueue: true,
            layout: "customBottomLeft",
            theme: "bootstrapTheme",
            closeWith: [],
            animation: {
                open: {
                    height: "toggle"
                },
                close: {
                    height: "toggle"
                },
                easing: "swing",
                speed: 250
            },
            buttons: [{
                addClass: "btn btn-primary",
                text: "Dismiss",
                onClick: function(n) {
                    n.close();
                    dismiss_func(toid, fromid);
                }
            }, {
                addClass: "btn btn-success",
                text: "Chat",
                onClick: function(n) {
                    n.close();
                    VINChatManager.Open(fromid);
                    dismiss_func(toid, fromid);
                }
            }],
            template: "<div class=\"activity-item\"><div class=\"activity\"><span class=\"noty_text\"></span></div></div>",
            callback: {
                onShow: function() {
                    if (otherdata == "msgalert") {
                        var al = { id: this.options.id, toid: toid, fromid: fromid };
                        alertNotys.push(al);
                    }
                }
            }
        });
    } else if (otherdata == "otheralert") {
        n = noty({
            text: msg,
            type: type,
            layout: "bottomLeft",
            theme: "bootstrapTheme",
            closeWith: [],
            animation: {
                open: {
                    height: "toggle"
                },
                close: {
                    height: "toggle"
                },
                easing: "swing",
                speed: 250
            },
            buttons: [{
                addClass: "btn btn-primary",
                text: "Dismiss",
                onClick: function(n) {
                    n.close();
                }
            }],
            template: "<div class=\"activity-item\"><div class=\"activity\"><span class=\"noty_text\"></span></div></div>"
        });
    }
}

// Proxy object 
var proxy = {
    disconnectCount: 0,
    HP: null,
    init: function(memid) {
        this.setUpHubProxy(memid);
        this.startConnection(this.HP);
        // Revisit if we want to only have one active connection
        //$j(window).blur(function () {
        //    proxy.HP.connection.stop();
        //});
        //$j(window).focus(function () {
        //    proxy.HP.connection.start();
        //});
    },
    closeAllNotys: function() {
        if (alertNotys.length > 0) {
            for (var i = 0; i < alertNotys.length; i++) {
                $j.noty.close(alertNotys[i].id);
            }
        }
    },
    setUpHubProxy: function(memid) {
        this.HP = this.getProxy(memid, "alertsHub");
        // SET UP EVENTS
        // set up send unviewed messages event
        this.HP.proxy.on("sendUnviewedMessages",
            function (data) {
                if ($j("#vinchat-badge").length === 0) {
                    return;
                }
                if (data === "0") {
                    $j("#vinchat-badge").html("").removeClass("vinchat-badge");
                } else {
                    $j("#vinchat-badge").html(data).addClass("vinchat-badge");
                }
            });
        // set up send alert event
        this.HP.proxy.on("sendAlerts",
            function(data) {
                proxy.closeAllNotys();
                // parse the data
                var json = JSON.parse(data);
                for (var i = 0; i < json.AlertsList.length; i++) {
                    newMessage(json.AlertsList[i].Message, "success", "msgalert", markAlert, json.AlertsList[i].ToId, json.AlertsList[i].FromId);
                }
                if (json.AlertsList.length > 0) {
                    _audioNotification.playSound();
                    setTimeout(function() {
                            proxy.closeAllNotys();
                        },
                        9000);
                }
            });
        // set up clear message alerts event
        this.HP.proxy.on("clearMessageAlerts",
            function(data) {
                if (alertNotys.length > 0) {
                    for (var i = 0; i < alertNotys.length; i++) {
                        if (data == alertNotys[i].fromid) {
                            $j.noty.close(alertNotys[i].id);
                        }
                    }
                }
            });
        // set up exec of signal for notification API
        this.HP.proxy.on("notificationAPI",
            function(data) {
                _vinnotification.setUpNotification("VIN Alert", "You have new messages in VIN Chat.");
            });
        // set up log message event
        this.HP.proxy.on("logMessage",
            function(data) {
                console.log(data);
            });
        // END SET UP EVENTS
    },
    // Return proxy object for signlar service
    getProxy: function(u, n) {
        var srvc = getService();
        srvc.connection = $j.hubConnection();
        srvc.connection.url = window.location.origin + "/VINChatAlerts/signalr/hubs";
        srvc.connection.qs = { "memberId": u };
        srvc.proxy = srvc.connection.createHubProxy(n);
        var conn = srvc.proxy.connection;
        conn.connectionSlow(function(evt) {
        });
        conn.reconnecting(function() {
        });
        conn.reconnected(function() {
            proxy.disconnectCount = 0;
        });
        conn.stateChanged(function(evt) {
            if (evt.newState == 1) {
                proxy.disconnectCount = 0;
            }
        });
        conn.disconnected(function (evt) {
            if (typeof (evt) === "undefined") {
            } else {
            }
            $j.noty.closeAll()
            if (typeof MyMemberId != "undefined") {
                if (proxy.disconnectCount < 7) {
                    setTimeout(function() {
                            proxy.disconnectCount++;
                            proxy.init(MyMemberId);
                        },
                        10000);
                } else {
                    console.log("VIN Chat connection has failed.");
                }
            }
        });
        return srvc;
    },
    // start the connection to the SignalR server 
    startConnection: function(proxy, doneCallback, failCallback) {
        proxy.connection.start().done(function() {
            if (typeof doneCallback !== "undefined") {
                doneCallback();
            }
        }).fail(function() {
            if (typeof failCallback !== "undefined") {
                failCallback();
            }
            console.log("major failure to connection");
        });
    }
};

// function to mark the alert as "read"
var markAlert = function(toid, fromid) {
    var args = JSON.stringify({ ToId: toid, FromId: fromid });
    proxy.HP.invoke("ChatUpdateMessageAlerted",
        args,
        function() {
        });
};

// Return core components/service for SignalR object
function getService() {
    var service = {
        connection: null,
        proxy: null,
        state: 0,
        on: function(eventName, callback) {
            this.proxy.on(eventName, function(result) {
                (function() {
                    if (callback) {
                        callback(result);
                    }
                });
            });
        },
        invoke: function(methodName, args, callback) {
            if (args !== null) {
                this.proxy.invoke(methodName, args)
                    .done(function(result) {
                        (function() {
                            if (callback) {
                                callback(result);
                            }
                        });
                    });
            } else {
                this.proxy.invoke(methodName)
                    .done(function(result) {
                        (function() {
                            if (callback) {
                                callback(result);
                            }
                        });
                    });
            }
        }
    };
    return service;
}

$j(document).ready(function() {
    if (IsImpersonation()) {
        console.log("VIN Chat alert is disabled; Impersonation is active.");
    } else {
        if (typeof MyMemberId !== "undefined") {
            if (typeof ($j.hubConnection) !== "undefined") {
                if (!ANM.LoadedInFrame) {
                    proxy.init(MyMemberId);
                }
            }
        }
    }
});
//*************************************************************************
// END VIN CHAT ALERT CODE
//*************************************************************************

// Check for impersonation
function IsImpersonation() {
    if ((typeof (isImpersonate) !== "undefined" && isImpersonate) || $j("#divImpersonation").length > 0 ) {
        return true;
    }
    return false;
}

var VINChatManager = function () {
    var _strUrl = "/Members/VinChatProxy/Default.aspx";

    var IsImpersonating = function (callBackTrue, callBackFalse) {
        $j.ajax({
            type: "GET",
            data: {},
            url: ANM.AlertsUrl + "/IsImpersonating",
            dataType: "json",
            success: function (result, status, xhr) {
                if (result) {
                    callBackTrue();
                } else {
                    callBackFalse();
                }
            },
            error: function (xhr, status, error) {
                console.log("IsImpersonating error!");
                console.log(xhr);
                callBackFalse();
            }
        });
    };

    var Open = function (intLaunchID, intSourceID) {
        var cbt = function () { alert("This feature is unavailable during impersonation"); return false; };
        var cbf = function () { Launch(intLaunchID, intSourceID); };
        VINChatManager.IsImpersonating(cbt, cbf);
    };

    var Launch = function (intLaunchID, intSourceID) {
        var strUrl = _strUrl;

        if (typeof (intLaunchID) !== "undefined" && intLaunchID !== null) {
            strUrl += "?LaunchID=" + intLaunchID;
        }

        if (typeof (intSourceID) !== "undefined" && intSourceID !== null) {
            if (!strUrl.includes("?")) {
                strUrl += "?SourceID=" + intSourceID;
            } else {
                strUrl += "&SourceID=" + intSourceID;
            }
        }

        var h = 600;
        var w = 900;
        var y = window.top.outerHeight / 2 + window.top.screenY - (h / 2);
        var x = window.top.outerWidth / 2 + window.top.screenX - (w / 2);

        var _VINChatWindow = window.open("", "VINChat", "toolbar=no,scrollbar=no,resizable=yes,width=" + w + ",height=" + h + ",top=" + y + ",left=" + x);
        if (_VINChatWindow.location.href === "about:blank") {
            _VINChatWindow.location.href = strUrl;
        }
        _VINChatWindow.focus();
    };

    return {
        IsImpersonating: IsImpersonating,
        Open: Open,
        Launch:Launch
    };
}();