var Accessibility = {
    siteRoot: '',
    ratio: 100,
    init: function () {
        jQuery.ajax({
            type: 'GET',
            url: Accessibility.siteRoot + '/accessibility.html',
            dataType: 'html',
            success: function (data) {
                jQuery('div.accessibility').html(data);
                jQuery(document.body).css("zoom", "100%");
                if (typeof (basic_view) == "number") {
                    jQuery('#basic_view_btn').show();
                }

                jQuery("#accessibility-helper-btn").off("click")
                    .on("click", function () {
                        var lefty = jQuery(".accessibility-helper-drawer-cont");
                        lefty.animate({
                            right: parseInt(lefty.css('right'), 10) == 0 ? -lefty.outerWidth() - 20 : 0
                        });
                    });
            }
        });
    },
    zoomIn: function () {
        console.log(">>>>>>>>>>>> CUR RATIO = " + Accessibility.ratio);
        Accessibility.ratio += 5;
        console.log(">>>>>>>>>>>> AFTER ZOOM IN RATIO = " + Accessibility.ratio);
        Accessibility.setZoomLevel(Accessibility.ratio / 100);
        //jQuery("body").css("zoom", (Accessibility.ratio + "%"));
        return false;
    },
    zoomOut: function () {
        console.log(">>>>>>>>>>>> CUR RATIO = " + Accessibility.ratio);
        Accessibility.ratio -= 5;
        console.log(">>>>>>>>>>>> AFTER ZOOM OUT RATIO = " + Accessibility.ratio);
        Accessibility.setZoomLevel(Accessibility.ratio / 100);
        //jQuery("body").css("zoom", (Accessibility.ratio + "%"));
        return false;
    },
    underlineLink: function () {
        console.log(">>>>>>>>>>>> underlining links");
        jQuery("body").toggleClass("is_underline");
    },
    readableFont: function () {
        console.log(">>>>>>>>>>>> switching to arial font");
        jQuery("body").toggleClass("arial_font_on");
    },
    grayscalePage: function () {
        console.log(">>>>>>>>>>>> grayscaling the page");
        jQuery("body").toggleClass("active_greyscale");
    },
    invertColors: function () {
        console.log(">>>>>>>>>>>> inverting colors");
        jQuery("body").toggleClass("invert_mode_on");
    },
    removeAnimations: function () {
        console.log(">>>>>>>>>>>> removing animations");
        jQuery("body").toggleClass("remove_animations");
    },
    switchToBasic: function () {
        console.log(">>>>>>>>>>>> toggling basic view");
        var url = window.location.href;
        if (url.indexOf("bv=1") > 0) {
            window.location = url.replace("bv=1", "");
            return;
        }
        if (url.indexOf("?") > 0) { window.location = url + "&bv=1"; }
        else { window.location = url + "?bv=1"; }
    },
    resetAccessibility: function () {
        console.log(">>>>>>>>>>>> reset!");
        Accessibility.ratio = 100;
        Accessibility.setZoomLevel(1);
        //jQuery("body").css("zoom", "100%");
        jQuery("body").removeClass("arial_font_on");
        jQuery("body").removeClass("is_underline");
        jQuery("body").removeClass("active_greyscale");
        jQuery("body").removeClass("invert_mode_on");
        jQuery("body").removeClass("remove_animations");
    },
    setZoomLevel: function (newRatio) {
        jQuery('body').css({
            'zoom': newRatio * 100 + '%',
            '-moz-transform-origin': '0 0',         /*Firefox*/
            '-moz-transform': 'scale(' + newRatio + ')', /*Firefox*/
        });
    }
};

jQuery(document).ready(function () {
    var i = document.getElementsByTagName('script');
    for (var j = 0; j < i.length; j++) {
        var k = i[j].src;
        if (k.indexOf('?') > 0) { k = k.substr(0, k.indexOf('?')); }
        if (k.indexOf('accessibility') > 0) {
            Accessibility.siteRoot = k.replace('/js/accessibility.js', '');
            break;
        }
    }

    jQuery('head').append('<link rel="stylesheet" type="text/css" href="' + Accessibility.siteRoot + '/css/accessibility.css">');
    jQuery('head').append('<link rel="stylesheet" type="text/css" href="' + Accessibility.siteRoot + '/icon/icomoon-disability/style.css">');

    Accessibility.init();
});