var agent = navigator.userAgent.toLowerCase();
var scrWidth = screen.width;
var scrHeight = screen.height;

//we can only trust clientWidth/clientHeight when we are on a page with "viewport max scale = 1"...
var elemWidth = document.documentElement.clientWidth;
var elemHeight = document.documentElement.clientHeight;

// If the screen orientation is defined we are in a modern mobile OS
var mobileOS = typeof orientation != 'undefined' ? true : false;
// If touch events are defined we are in a modern touch screen OS
var touchOS = ('ontouchstart' in document.documentElement) ? true : false;

// iPhone and iPad can be reliably identified with the navigator.platform string, which is currently only available on these devices.
// but using agent so it can more easily be simulated
var iOS = (agent.indexOf("iphone") != -1) || (agent.indexOf("ipad") != -1) || (agent.indexOf("ipod") != -1) ? true : false;

var iOS6 = (iOS && agent.indexOf("os 6") != 1);

// If the user agent string contains "android" then it's Android
var winrt = (agent.indexOf("msie") != -1 && agent.indexOf("arm") != -1) ? true : false;
var android = (agent.indexOf("android") != -1) ? true : false;
var mobile = (agent.indexOf("mobile") != -1) ? true : false;

//check if mobile OS
var isMobileOS = (iOS || android || (mobileOS && touchOS) || winrt);

//check if device is tablet
var has1024 = (elemWidth >= 900 && elemHeight >= 640) || (elemWidth >= 640 && elemHeight >= 900);
var isTablet = (((!android && isMobileOS) || (android && !mobile)) && has1024) ? true : false;

//check if device is phone
var isPhone = (isMobileOS && !isTablet) ? true : false;

//checks if touch device (TODO: also defined in html5_wb.js - very bad has to be in one place)
function isTouchDevice() {

	if (/chrome/.test(navigator.userAgent.toLowerCase())) {
		return false;
	}

	if ("createTouch" in document) {
		return true;
	}

	try {

		var event = document.createEvent("TouchEvent");
		return !!event.initTouchEvent;

	} catch (e) {
		return false;
	}
}