$(function () {
	$.fn.hint = function () {
		return this.each(function () {
			var $input = $(this);
			var title = $input.attr('title');

			if (typeof (title) == 'undefined')
				return;

			$input.focus(function () {
				if ($input.val() === title) {
					//special case for password box
					if ($input.attr('id') == 'PasswordPlaceholder') {
						$input.hide();
						$('.RealPassword').show().focus();
					}
					else {
						$input.val('');
						$input.removeClass('hinted');
					}
				}
			});

			$input.blur(function () {
				if ($input.val() === '' || $input.val() === title) {
					//special case for password box		
					if ($input.hasClass('RealPassword')) {
						$input.hide();
						$('#PasswordPlaceholder').show();
					}
					else {
						$input.val(title);
						$input.addClass('hinted');
						$input.removeClass('inputValid');
					}
				}
				else
					$input.removeClass('hinted');
			});

			$input.change(function () {
				if ($input.val() === '')
					$input.addClass('hinted');
				else
					$input.removeClass('hinted');
			});
			
			$input.blur();
		});
	};
});

$(function () {
	$('input[title!=""]').hint();
	$('textarea[title!=""]').hint();
	$('select.hinted').hint();
});