/**
* Re-assigns a couple of the ASP.NET validation JS functions to
* provide a more flexible approach
*/
// Hi-jack the ASP.NET error display only if required
if (typeof (Page_ClientValidate) != "undefined") {
	AspPage_ValidatorUpdateDisplay = ValidatorUpdateDisplay;
	ValidatorUpdateDisplay = NicerValidatorUpdateDisplay;
	//AspPage_ClientValidate = Page_ClientValidate;
	//Page_ClientValidate = NicerPage_ClientValidate;
}

/**
* Extends the classic ASP.NET validation to add a class to the parent span when invalid
*/
function NicerValidatorUpdateDisplay(val) {
	AspPage_ValidatorUpdateDisplay(val);

	//any other validators on for this control?
	var c = jQuery(val).siblings('input,select,textarea');

	var x = c.siblings('span:visible');

	if (val.isvalid && x.length == 0) {
		c.removeClass('inputInvalid');
		c.addClass('inputValid');
		//$(val).prevAll('select').removeClass('inputInvalid');
	} else {
		c.addClass('inputInvalid');
		c.removeClass('inputValid');
		//$(val).prevAll('select').addClass('inputInvalid');
	}
}

/**
* Extends classic ASP.NET validation to include parent element styling
*
function NicerPage_ClientValidate(validationGroup) {
	var valid = AspPage_ClientValidate(validationGroup);

	if (!valid) {
		// do custom styling etc
		// I added a background colour to the parent object
		$(this).parent().addClass('invalidField');
	}
}
*/