try {
    $j(document).on("ProjectsMenuTreeLoaded",
        function (ev, tree) {
            var treeEl = tree.element;
            var selectedNode = $j(treeEl).find(".tree-node-ctrl.selected").closest(".tree-node");
            var nextNodeURL = $j(selectedNode).data("nextnodeurl");
            var prevNodeURL = $j(selectedNode).data("prevnodeurl");

            if (typeof (prevNodeURL) != "undefined" && prevNodeURL.length > 0) {
                $j("div.PreviousNextLeft").each(function (val, obj) {
                    var link = $j(obj).find("a");
                    $j(link).attr("href", prevNodeURL);
                    $j(obj).show();
                });
            }
            if (typeof (nextNodeURL) != "undefined" && nextNodeURL.length > 0) {
                $j("div.PreviousNextRight").each(function (val, obj) {
                    var link = $j(obj).find("a");
                    $j(link).attr("href", nextNodeURL);
                    $j(obj).show();
                });
            }
        });
} catch (ex) {
}

EventManager.addHandler("ProjectsMenuTree",
    "NextPreviousDocs",
    function (tree, info) {
        if (info == null) return;
        $$("div.PreviousNextLeft").each(function (item) {
            if (info.previousLink.length > 0) {
                var link = item.down("a");
                link.title = info.previousText;
                if (info.previousNewWindow) {
                    Event.observe(link,
                        "click",
                        function (ev) {
                            window.location = info.previousInternalLink;
                            window.open(info.previousLink, "_blank", __STANDARD_POPUP_FEATURES__);
                            ev.stop();
                        });
                } else {
                    link.href = info.previousLink;
                }
                item.show();
            }
        });
        $$("div.PreviousNextRight").each(function (item) {
            if (info.nextLink.length > 0) {
                var link = item.down("a");
                link.title = info.nextText;
                if (info.nextNewWindow) {
                    Event.observe(link,
                        "click",
                        function (ev) {
                            window.location = info.nextInternalLink;
                            window.open(info.nextLink, "_blank", __STANDARD_POPUP_FEATURES__);
                            ev.stop();
                        });
                } else {
                    link.href = info.nextLink;
                }
                item.show();
            }
        });
    });

EventManager.addHandler("ProjectsMenuTreeMobile",
    "NextPreviousDocs",
    function (tree, info) {
        if (info == null) return;
        $$("div.PreviousNextLeft").each(function (item) {
            if (info.previousLink.length > 0) {
                var link = item.down("a");
                link.title = info.previousText;
                if (info.previousNewWindow) {
                    Event.observe(link,
                        "click",
                        function (ev) {
                            window.location = info.previousInternalLink;
                            window.open(info.previousLink, "_blank", __STANDARD_POPUP_FEATURES__);
                            ev.stop();
                        });
                } else {
                    link.href = info.previousLink;
                }
                item.show();
            }
        });
        $$("div.PreviousNextRight").each(function (item) {
            if (info.nextLink.length > 0) {
                var link = item.down("a");
                link.title = info.nextText;
                if (info.nextNewWindow) {
                    Event.observe(link,
                        "click",
                        function (ev) {
                            window.location = info.nextInternalLink;
                            window.open(info.nextLink, "_blank", __STANDARD_POPUP_FEATURES__);
                            ev.stop();
                        });
                } else {
                    link.href = info.nextLink;
                }
                item.show();
            }
        });
    });