$ = jQuery;
$(document).ready(function(){
  var $error = 0;
  var $itemName;
  var $itemPrice;
  var $itemCount = 0;
  var $itemEdge;
  var $itemSkin;
  var $itemSkinPrice;
  var $itemTotal;

  function scrollToAnchor(sid){
    var sectionid = $("#"+ sid +"']");
    $('html,body').animate({scrollTop: sectionid.offset().top},'slow');
  }

  // Active Item
  $("body").on("click", ".calculate-page .container-page .middle-section.stone-products .item", function(){
    var $item = $(this);
    if ($(this).hasClass('active')) {
      $(this).toggleClass('active');
    }else{
      $('.calculate-page .container-page .middle-section.stone-products .item').removeClass('active');
      $(this).addClass('active');
    }
    $itemName = $item.data('name');
    $itemPrice = $item.data('price');
  });

  $('.ebs-calc-additional-info .additional-item.additional-info-sqft input').change(function(){
    $itemCount = $(this).val();
  });
  $('.ebs-calc-additional-info .additional-item.additional-info-edge select').change(function(){
    $itemEdge = $(this).val();
  });
  $('.ebs-calc-additional-info .additional-item.additional-info-skin select').change(function(){
    $itemSkin = $(this).val();
    $itemSkinPrice = $('option:selected', this).data('price');
  });

  function calcPrice(){

    if(!$itemName){

      $error = 1;

      $('.calculate-page .error-item-selected').fadeIn();

    }else if(!$itemCount){
      $('.calculate-page .error-item-selected').fadeOut();
      $('.ebs-calc-additional-info .additional-item.additional-info-sqft input').parent().addClass('showError');

    }else if(!$itemEdge){
      $('.ebs-calc-additional-info .additional-item.additional-info-sqft input').parent().removeClass('showError');
      $('.ebs-calc-additional-info .additional-item.additional-info-edge select').parent().addClass('showError');

    }else if(!$itemSkin){
      $('.ebs-calc-additional-info .additional-item.additional-info-edge select').parent().removeClass('showError');
      $('.ebs-calc-additional-info .additional-item.additional-info-skin select').parent().addClass('showError');
    }else{
      $('.calculate-page .ebs-send-form-wrapper').fadeIn();
      $('.calculate-page .error-item-selected').fadeOut();
      $("html, body").animate({ scrollTop: $('#sendForm').offset().top - 50 }, 500);
      $('.ebs-calc-additional-info .additional-item.additional-info-skin select').parent().removeClass('showError');
      $('.calculate-page .ebs-send-form-wrapper form .ebs-total-name input').val($itemName);
      $('.calculate-page .ebs-send-form-wrapper form .ebs-total-item-price input').val($itemPrice);
      $('.calculate-page .ebs-send-form-wrapper form .ebs-total-item-count input').val($itemCount);
      $('.calculate-page .ebs-send-form-wrapper form .ebs-total-edge input').val($itemEdge);
      // $('.calculate-page .ebs-send-form-wrapper form .total-sinks input').val($itemSkin + " ("+$itemSkinPrice+")");
      $('.calculate-page .ebs-send-form-wrapper form .total-sinks input').val($itemSkin);
      $('.calculate-page .ebs-send-form-wrapper form .price-sinks input').val($itemSkinPrice);
      if(!$.isNumeric($itemSkinPrice)) {
         $('.calculate-page .ebs-send-form-wrapper form .ebs-total-price input').val($itemPrice*$itemCount);
      }else{
        $('.calculate-page .ebs-send-form-wrapper form .ebs-total-price input').val(($itemPrice*$itemCount)+$itemSkinPrice);
      }
    }
  }
  $('.calc-btn').on('click', function(){
    calcPrice();
  });

  var $numPage = 1;
  function loadMoreitems(){
    var $filter_color = $("#stonesColor").val();
    var $filter_material = $("#stonesMaterial").val();

    $.ajax({
        url: ajaxurl,
        type: 'POST',
        data: {
          'filter_color': $filter_color,
          'filter_material': $filter_material,
          'numPage' : $numPage,
          action: 'load_filter',
        },
        success: function(respons){
          if ($numPage > 1) {
            $('.middle-section.stone-products').append(respons);
          } else {
            $('.middle-section.stone-products').html(respons);
          }
          var countPosts = $('.middle-section.stone-products .item').length;
          var totalItems = $('.middle-section.stone-products .item:first').data('total');
          $('.calculate-page .all-stones span').html(totalItems);
          $('.calculate-page .calc-pagi .pagi-info .pagi-info-item.pagi-current').html(countPosts);
          $('.calculate-page .calc-pagi .pagi-info .pagi-info-item.pagi-all').html(totalItems);

          if (countPosts >= totalItems || totalItems < 12 || totalItems == undefined) {
            $('.calculate-page .calc-pagi .page-numbers.next').hide();
          }else{
            $('.calculate-page .calc-pagi .page-numbers.next').show();
          }
          if(respons.length == 0){
            $('.calculate-page .all-stones span').html('0');
            $('.middle-section.stone-products').html('<div class="no-stones">No Stones.</div>');
          }
        }
    });
  }

  // Ajax Filter
  $("#stonesColor, #stonesMaterial").change(function () {
    $numPage = 1;
    loadMoreitems();
  });
  $("#stonesMaterial").change(function () {
    $('.category-right .dropdown-wrapp.material span').text('-- select color --');
  });

  // Ajax Load More
  $('.calc-pagi .next').on('click', function(e){
    e.preventDefault();
    $numPage++;
    loadMoreitems();
  });

/*Dropdown Menu*/
  $('.dropdown-wrapp').click(function () {
      $(this).attr('tabindex', 1).focus();
      $(this).toggleClass('active');
      $(this).find('.dropdown-menu').slideToggle(300);
  });
  $('.dropdown-wrapp').focusout(function () {
      $(this).removeClass('active');
      $(this).find('.dropdown-menu').slideUp(300);
  });
  $('.dropdown-wrapp .dropdown-menu .menu-item').click(function () {
      $(this).parents('.dropdown-wrapp').find('span').text($(this).text());
      $(this).parents('.dropdown-wrapp').find('input').val($(this).attr('rel')).trigger('change');
      $(this).parents('.dropdown-wrapp').find('select').val($(this).attr('rel')).trigger('change');
  });
  $(document).ready(function () {
  	$('.dropdown-wrapp select').each(function(){
      $(this).parents('.dropdown-current').find('span').text($(this).val());
  	})
  });
/*End Dropdown Menu*/

$(window).load(function(){
  if($('.calculate-page .container-page .middle-section.stone-products .item').hasClass('selected-product')){
    $('.calculate-page .container-page .middle-section.stone-products .item.selected-product').click();
  }
});

});